package net.aihelp.ui.webkit;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;

import net.aihelp.common.Const;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;
import net.aihelp.utils.ToastUtil;

import java.net.URISyntaxException;

public class AIHelpWebViewClient extends WebViewClient {

    public static final String TAG = AIHelpWebViewClient.class.getSimpleName();
    private Context context;
    private AIHelpWebProgress webProgress;
    private ShouldOverrideUrlLoadingListener mUrlLoadingListener;
    private OnPageLoadingProgressListener mPageLoadingProgressListener;

    public void setOnPageLoadingProgressListener(OnPageLoadingProgressListener mPageLoadingProgressListener) {
        this.mPageLoadingProgressListener = mPageLoadingProgressListener;
    }

    public void setUrlLoadingListener(ShouldOverrideUrlLoadingListener mUrlLoadingListener) {
        this.mUrlLoadingListener = mUrlLoadingListener;
    }

    public AIHelpWebViewClient(Context context, AIHelpWebProgress webProgress) {
        this.context = context;
        this.webProgress = webProgress;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        boolean ret = Build.VERSION.SDK_INT >= 24 && this.handleUrlClick(view, request.getUrl().toString()) || super.shouldOverrideUrlLoading(view, request);
        if (mUrlLoadingListener != null) {
            mUrlLoadingListener.handleUrlClick(ret);
        }
        return ret;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        boolean ret = Build.VERSION.SDK_INT < 24 && this.handleUrlClick(view, url) || super.shouldOverrideUrlLoading(view, url);
        if (mUrlLoadingListener != null) {
            mUrlLoadingListener.handleUrlClick(ret);
        }
        return ret;
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        webProgress.show();
        if (mPageLoadingProgressListener != null) {
            mPageLoadingProgressListener.onPageStarted(view, url);
        }
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (mPageLoadingProgressListener != null) {
            mPageLoadingProgressListener.onPageFinished(view, url);
        }
    }

    // 这个方法只会响应点击，第一次加载不走这里
    private boolean handleUrlClick(WebView view, String url) {
        Context context = view.getContext();
        if (AppInfoUtil.isNetworkAvailable(context)) {
            if (TextUtils.isEmpty(url)) return true;
            if (url.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null) {
                Const.sOnSpecificUrlClickedListener.onSpecificUrlClicked(url);
                return true;
            }
            if (url.startsWith("intent://") || url.startsWith("jsbridge://")) {
                try {
                    Intent intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME);
                    if (intent != null) {
                        intent.addCategory(Intent.CATEGORY_BROWSABLE);
                        intent.setComponent(null);
                        intent.setSelector(null);
                        PackageManager packageManager = context.getPackageManager();
                        ResolveInfo info = packageManager.resolveActivity(intent, PackageManager.MATCH_DEFAULT_ONLY);
                        if (info != null) {
                            context.startActivity(intent);
                        } else {
                            String fallbackUrl = intent.getStringExtra("browser_fallback_url");
                            view.loadUrl(fallbackUrl);
                        }
                        return true;
                    }
                } catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        } else {
            ToastUtil.makeRawToast(context, ResResolver.getString("aihelp_network_no_connect"));
            return true;
        }
        return false;
    }

    public interface ShouldOverrideUrlLoadingListener {
        void handleUrlClick(boolean result);
    }

    @Override
    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        super.onReceivedSslError(view, handler, error);
        String message;
        switch (error.getPrimaryError()) {
            case SslError.SSL_DATE_INVALID:
                message = "SSL_DATE_INVALID";
                break;
            case SslError.SSL_EXPIRED:
                message = "SSL_EXPIRED";
                break;
            case SslError.SSL_IDMISMATCH:
                message = "SSL_IDMISMATCH";
                break;
            case SslError.SSL_INVALID:
                message = "SSL_INVALID";
                break;
            case SslError.SSL_NOTYETVALID:
                message = "SSL_NOTYETVALID";
                break;
            case SslError.SSL_UNTRUSTED:
                message = "SSL_UNTRUSTED";
                break;
            default:
                message = "SslError unknown";
        }
        Log.d(TAG, "onReceivedSslError: " + message);
    }

    public interface OnPageLoadingProgressListener {
        void onPageStarted(WebView view, String url);
        void onPageFinished(WebView view, String url);
    }

}
