package net.aihelp.ui.op;

import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;


import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.ui.loading.helper.VaryViewHelperController;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.OperatePagerEvent;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.event.SearchViewVisibilityChangeEvent;
import net.aihelp.data.event.SupportActionEvent;

import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.op.OperateSection;
import net.aihelp.ui.adapter.OperateViewPagerAdapter;
import net.aihelp.ui.helper.EvaluateNewHelper;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.widget.tabs.TabLayout;
import net.aihelp.ui.widget.tabs.TabLayoutMediator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager2.widget.ViewPager2;

public class OperationFragment extends BaseFragment {

    public static OperationFragment newInstance(Bundle bundle) {
        OperationFragment fraOperate = new OperationFragment();
        fraOperate.setArguments(bundle);
        return fraOperate;
    }

    private OperateViewPagerAdapter mAdapter;

    private boolean isContactUsAlwaysOnline;
    private int mCurrentItem;
    private String elvaTitle = ResResolver.getString("aihelp_op_cs");

    private View operateView;
    private boolean isNowInOperatePage;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatisticHelper.whenOperationVisible();
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        operateView = inflater.inflate(ResResolver.getLayoutId("aihelp_fra_operate"), null);
        return operateView;
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_operate_root");
    }

    @Override
    public void onViewCreated(@NonNull final View view, @Nullable Bundle savedInstanceState) {
        View targetView = view.findViewById(getLoadingTargetViewId());
        if (targetView != null) {
            mVaryViewHelperController = new VaryViewHelperController(targetView);
        }

//        // Download operate file when open AIHelp session
//        if (!Const.TOGGLE_LOCALIZE_VIA_INIT && !AIHelpDBHelper.getInstance().isOperateStoredSuccessfully()) {
//            if (!EventBus.getDefault().isRegistered(this)) {
//                EventBus.getDefault().register(this);
//            }
//            showLoading();
//            LocalizeHelper.getLocalizeDataFromUrl(LocalizeHelper.FLAG_OP);
//            return;
//        }

//        ApiExecutor apiExecutor = ApiExecutorFactory.getHandlerExecutor();
//        apiExecutor.runAsync(new Runnable() {
//            @Override
//            public void run() {
//                final List<OperateSection> operateSectionList = OperateDBHelper.getOperateSectionList();
//                apiExecutor.runOnUiThread(new Runnable() {
//                    @Override
//                    public void run() {
//                        createOperateView(view, operateSectionList);
//                    }
//                });
//            }
//        });

        final List<OperateSection> operateSectionList = OperateHelper.INSTANCE.getOperateSections();
        createOperateView(view, operateSectionList);

    }

//    @Override
//    public void onEventComing(EventCenter event) {
//        if (event instanceof OperateDataPreparedEvent) {
//            restoreViewState();
//            createOperateView(operateView);
//        }
//    }

    private void createOperateView(@NonNull View view, List<OperateSection> operateSectionList) {
        final TabLayout tabLayout = view.findViewById(ResResolver.getViewId("aihelp_tab"));
        tabLayout.setBackgroundColor(Styles.getColorWithAlpha(
                CustomConfig.CommonSetting.navigationBarBackground, CustomConfig.CommonSetting.navigationBarAlpha));
        tabLayout.setVisibility(operateSectionList.size() == 0 ? View.GONE : View.VISIBLE);
        tabLayout.setSelectedTabIndicatorColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));

        final ViewPager2 viewPager = view.findViewById(ResResolver.getViewId("aihelp_view_pager"));

        if (getActivity() == null) {
            TLog.e("OperationFragment getActivity() returns null!");
            return;
        }

        mAdapter = new OperateViewPagerAdapter(getActivity(), getArguments(), operateSectionList);
        viewPager.setAdapter(mAdapter);

        final Bundle bundle = getArguments();
        if (bundle != null) {
            isContactUsAlwaysOnline = getArguments().getBoolean(IntentValues.CONTACT_US_ALWAYS_ONLINE);
            mCurrentItem = getArguments().getInt(IntentValues.OPERATE_SELECT_INDEX);
            elvaTitle = getArguments().getString(IntentValues.OPERATE_SUPPORT_BOT_TITLE,
                    ResResolver.getString("aihelp_op_cs"));
        }

        viewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {

            @Override
            public void onPageSelected(int position) {

                Log.e("TAG", "position -------- " + position);

                EventBus.getDefault().post(new UpdateTitleEvent(UpdateTitleEvent.CUSTOM_SERVICE,
                        CustomConfig.CustomerService.csNavigationBarTitleIcon,
                        CustomConfig.CustomerService.csNavigationTitle));

                // Checkout if all articles under this section have been read after every page select.
                // If all articles have been read, clear the notification marked on current tabView.
                boolean isCurrentSectionAllRead = true;
                if (position < mAdapter.getItemCount() - 1) {
                    String sectionId = operateSectionList.get(position).getId();
                    isCurrentSectionAllRead = !OperateHelper.INSTANCE.isSectionUnread(sectionId);
                }

                // Update selected tabView typeface and the unread notification after selected a page
                for (int i = 0; i < tabLayout.getTabCount(); i++) {
                    TabLayout.Tab tab = tabLayout.getTabAt(i);
                    if (tab != null) {
                        if (tab.getCustomView() instanceof RelativeLayout) {
                            RelativeLayout customView = (RelativeLayout) tab.getCustomView();
                            ((TextView) (customView).getChildAt(0)).setTypeface(tab.getPosition() == position ?
                                    Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
                            if (i == position && isCurrentSectionAllRead) {
                                customView.getChildAt(1).setVisibility(View.GONE);
                            }
                        }
                    }
                }

                if (bundle != null) {
                    EventBus.getDefault().post(new OperatePagerEvent(position == mAdapter.getItemCount() - 1));
                    if (position == mAdapter.getItemCount() - 1) {
                        if (bundle.getBoolean(IntentValues.HUMAN_EMBEDDED_IN_OPERATION)) {
                            EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
                        } else {
                            if (ResponseMqttHelper.isFormSubmitted()) {
                                EventBus.getDefault().post(new PageHoppingEvent(IntentValues.PAGE_HOPPING_CONVERSATION));
                            } else {
                                ResponseMqttHelper.updateElvaSupportActionStatus(isContactUsAlwaysOnline);
                            }
                        }
                    } else {
                        EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION, IntentValues.SUPPORT_ACTION_FAQ));
                    }
                }

            }

        });

        TabLayoutMediator mediator = new TabLayoutMediator(tabLayout, viewPager, true, new TabLayoutMediator.TabConfigurationStrategy() {
            @Override
            public void onConfigureTab(@NonNull TabLayout.Tab tab, int position) {

                RelativeLayout tabViewLayout = new RelativeLayout(getContext());
                tabViewLayout.setLayoutParams(new ViewGroup.MarginLayoutParams(
                        ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.MATCH_PARENT
                ));

                // Tab text
                TextView textView = new TextView(getContext());
                RelativeLayout.LayoutParams textViewLayoutParams = new RelativeLayout.LayoutParams(
                        ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT
                );
                textViewLayoutParams.addRule(RelativeLayout.CENTER_VERTICAL);
                textView.setLayoutParams(textViewLayoutParams);

                int[][] states = new int[2][];
                states[0] = new int[]{android.R.attr.state_selected};
                states[1] = new int[]{};

                int[] colors = new int[]{Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor),
                        Color.parseColor(CustomConfig.CommonSetting.textColor)};
                ColorStateList colorStateList = new ColorStateList(states, colors);

                String title = position == mAdapter.getItemCount() - 1 ?
                        elvaTitle : operateSectionList.get(position).getTitle();
                textView.setText(title);
                textView.setTextSize(15);
                textView.setSingleLine();
                textView.setEllipsize(TextUtils.TruncateAt.END);
                textView.setTextColor(colorStateList);
                textView.setGravity(Gravity.CENTER);
                tabViewLayout.addView(textView);

                // Notification
                View unreadStatus = new View(getContext());
                unreadStatus.setVisibility(View.GONE);
                RelativeLayout.LayoutParams notificationLayoutParams = new RelativeLayout.LayoutParams(
                        dip2px(getContext(), 7), dip2px(getContext(), 7));
                notificationLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                notificationLayoutParams.rightMargin = dip2px(getContext(), 10);
                notificationLayoutParams.topMargin = dip2px(getContext(), 10);
                unreadStatus.setLayoutParams(notificationLayoutParams);
                unreadStatus.setBackgroundResource(ResResolver.getDrawableId("aihelp_bg_msg_unread"));
                tabViewLayout.addView(unreadStatus);

                // Mark a notification if there are unread articles in current section.
                if (Const.sOperationUnreadListener != null && position < mAdapter.getItemCount() - 1) {
                    String secId = operateSectionList.get(position).getId();
                    if (OperateHelper.INSTANCE.isSectionUnread(secId)) {
                        unreadStatus.setVisibility(View.VISIBLE);
                    }
                }
                tab.setCustomView(tabViewLayout);
            }
        });
        mediator.attach();

        // Update page select after all registers are finished.
        if (!isNowInOperatePage) {
            isNowInOperatePage = true;
            if (mCurrentItem >= mAdapter.getItemCount() - 1) {
                viewPager.setCurrentItem(mAdapter.getItemCount() - 1, false);
                EventBus.getDefault().post(new OperatePagerEvent(true));
                ResponseMqttHelper.updateElvaSupportActionStatus(isContactUsAlwaysOnline);
            } else {
                viewPager.setCurrentItem(mCurrentItem, false);
            }
        }


    }

    @Override
    protected void initEventAndData(View contentView) {
    }

    @Override
    protected int getLayout() {
        return 0;
    }

    public boolean onBackPressed() {
        if (mAdapter.getElvaBotFragment() != null) {
            return mAdapter.getElvaBotFragment().onBackPressed();
        }
        return true;
    }

//    @Override
//    public void onDestroy() {
//        super.onDestroy();
//        if (EventBus.getDefault().isRegistered(this)) {
//            EventBus.getDefault().unregister(this);
//        }
//    }
}
