package net.aihelp.ui.op;

import android.os.Bundle;
import android.view.View;


import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;

import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.ui.SupportFragment;
import net.aihelp.ui.adapter.OperateListAdapter;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.faq.IFaqParentView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.List;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class OperateListFragment extends BaseFragment {

    public static OperateListFragment getInstance(Bundle bundle) {
        OperateListFragment fraOperateList = new OperateListFragment();
        fraOperateList.setArguments(bundle);
        return fraOperateList;
    }

    private RecyclerView opList;
    private OperateListAdapter operateAdapter;

    @Override
    protected void initEventAndData(View contentView) {
        opList = (RecyclerView) get("aihelp_rv_operate");
        opList.setLayoutManager(new LinearLayoutManager(getContext()));
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        opList.setBackgroundColor(colorFromHex);

        operateAdapter = new OperateListAdapter(getContext(), new OperateListAdapter.OnOperationFaqClickedListener() {
            @Override
            public void onOperationFaqClicked(String faqId) {
                Bundle bundle = getArguments();
                if (bundle == null) {
                    bundle = new Bundle();
                }
                bundle.putString(IntentValues.FAQ_MAIN_ID, faqId);
                if (getFaqFlowListener() != null) {
                    getFaqFlowListener().onIntentToOperateContent(bundle);
                }
            }
        });

        opList.setAdapter(operateAdapter);
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        if (extras != null) {
            String sectionId = extras.getString(IntentValues.OPERATE_SECTION_ID);
            List<OperateArticle> articles = OperateHelper.INSTANCE.getOperateArticles(sectionId);
            operateAdapter.update(articles, true);
        }
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_operate_list");
    }

    private IFaqEventListener getFaqFlowListener() {
        FragmentManager fragmentManager = getFragmentManager();
        for (Fragment fragment : fragmentManager.getFragments()) {
            if (fragment instanceof SupportFragment) {
                return ((IFaqParentView) fragment).getFaqEventListener();
            }
        }
        return null;
    }

}
