package net.aihelp.ui.op;

import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;


import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.logic.OperatePresenter;

import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateView;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;


public class OperateContentFragment extends BaseFragment<OperatePresenter> {

    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;
    private AIHelpEvaluateView mEvaluateView;

    public static OperateContentFragment newInstance(Bundle bundle) {
        OperateContentFragment faqFragment = new OperateContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {

        FrameLayout flContent = get("aihelp_fl_operate_root");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        flContent.setBackgroundColor(colorFromHex);

        mEvaluateView = get("aihelp_evaluate_op");
        mProgressBar = get("aihelp_progress_bar");

        mWebView = get("aihelp_web_view");
        mWebView.setBackgroundColor(Color.TRANSPARENT);
        mWebView.setWebViewClient(new AIHelpWebViewClient(getContext(), mProgressBar));
        mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, mProgressBar));

    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
        mPresenter.goFetchOperateContent(extras.getString(IntentValues.FAQ_MAIN_ID));
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_operate_content");
    }

    public void refreshOperateContent(OperateArticle article) {
        // prepare AIHelpEvaluateView
        mEvaluateView.setMainId(article.getFaqMainId());
        mEvaluateView.setContentId(article.getFaqContentId());
        if (CustomConfig.CommonSetting.isEvaluationForOperationEnable && mPresenter.shouldShowEvaluateFooter(article.getFaqMainId())) {
            mEvaluateView.setEvaluateState(AIHelpEvaluateView.STATE_NORMAL);
        } else {
            mEvaluateView.setEvaluateState(AIHelpEvaluateView.STATE_INVISIBLE);
        }
        mEvaluateView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateView.OnAIHelpEvaluateViewCallback() {
            @Override
            public void onEvaluated(boolean isHelpful) {
                OperateHelper.INSTANCE.afterArticleEvaluated(article.getFaqMainId());
            }
        });

        // update article content
        String faqContent = DomainSupportHelper.correctDomain(article.getFaqContent());
        int[] colorRGB = Styles.getColorRGB(CustomConfig.CommonSetting.textColor);
        String textColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 1);
        String timeColor = String.format("color: rgba(%s, %s, %s, %s)", colorRGB[0], colorRGB[1], colorRGB[2], 0.3);
        faqContent = faqContent.replace("<body>", String.format("<body style=\"background-color: transparent; %s\">", textColor));
        faqContent = faqContent.replace("<div style='font-size:14px;color:#CCCCCC;'>", String.format("<div style='font-size:14px; %s'>", timeColor));
        mWebView.loadDataWithBaseURL(null, faqContent, "text/html", "utf-8", null);
        StatisticHelper.whenOperationArticleVisible(article.getFaqMainId());
        StatisticHelper.whenOperationArticleVisibleWithCollectApi(article.getFaqContentId());

        // If this is the last unread article, notify the observers at here
        if (Const.sOperationUnreadListener != null && !mPresenter.haveUnreadArticles()) {
            Const.sOperationUnreadListener.onOperationUnreadChanged(false);
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        mProgressBar.hide();
    }

    public boolean onBackPressed() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
            return false;
        }
        return true;
    }

}
