package net.aihelp.ui.helper;

import android.content.Intent;
import android.os.Build;

import net.aihelp.common.Const;


public class AttachmentDataProvider {

    public static final int PICK_ATTACHMENT_REQUEST_ID = 1;
    public static final int PICK_ATTACHMENT_WITHOUT_PERMISSIONS_REQUEST_ID = 2;

    public static Intent getIntentForMedia(boolean hasPermission) {
        Intent mediaIntent;
        if (!hasPermission && Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT){
            mediaIntent = new Intent(Intent.ACTION_OPEN_DOCUMENT);
        }else {
            mediaIntent = new Intent(Intent.ACTION_GET_CONTENT);
        }
        if (Const.TOGGLE_UPLOAD_VIDEO) {
            mediaIntent.setType("image/* video/*");
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                mediaIntent.putExtra(Intent.EXTRA_MIME_TYPES, new String[]{"image/*", "video/*"});
            }
        } else {
            mediaIntent.setType("image/*");
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
                mediaIntent.putExtra(Intent.EXTRA_MIME_TYPES, new String[]{"image/*"});
            }
        }
        mediaIntent.putExtra(Intent.EXTRA_LOCAL_ONLY, true);
        mediaIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);
        mediaIntent.addFlags(Intent.FLAG_GRANT_WRITE_URI_PERMISSION);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            mediaIntent.addFlags(Intent.FLAG_GRANT_PERSISTABLE_URI_PERMISSION);
        }
        return mediaIntent;
    }
}
