package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.RelativeLayout;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.ui.adapter.faq.FaqCardLayoutAdapter;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class FaqListFragment extends BaseFaqFragment<FaqPresenter> {

    private String currentSectionId;
    private FaqCardLayoutAdapter mAdapter;

    public static FaqListFragment newInstance(Bundle bundle) {
        FaqListFragment faqFragment = new FaqListFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
        currentSectionId = extras.getString(IntentValues.SECTION_ID);
    }

    @Override
    protected void initEventAndData(View mView) {

        RelativeLayout rlSearch = get("aihelp_rl_search");
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        rlSearch.setBackgroundColor(colorFromHex);

        RecyclerView rvSubSection = get("aihelp_rv_faq_search");
        rvSubSection.setLayoutManager(new LinearLayoutManager(getContext()));
        mAdapter = new FaqCardLayoutAdapter(getContext(), true);
        mAdapter.setup(getMergedBundle(), getFaqFlowListener());
        mAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper() {

            final Bundle bundle = getMergedBundle();

            @Override
            public void onIntentToSubSectionOrQuestionList(FaqListEntity faq) {
                bundle.putString(IntentValues.SECTION_ID, faq.getId());
                bundle.putString(IntentValues.SECTION_NAME, faq.getTitle());
                bundle.putString(IntentValues.SECTION_ICON, faq.getIconUrl());
                getFaqFlowListener().onIntentToQuestionList(bundle);
            }

            @Override
            public void onIntentToQuestionContent(String faqId, String match) {
                bundle.putString(IntentValues.SECTION_ID, currentSectionId);
                bundle.putString(IntentValues.FAQ_MAIN_ID, faqId);
                getFaqFlowListener().onIntentToQuestionContent(bundle);
            }

        });
        rvSubSection.setAdapter(mAdapter);

    }

    @Override
    protected void getBundleAfterDataPrepared(@NonNull Bundle extras) {
        String sectionId = extras.getString(IntentValues.SECTION_ID);
        mPresenter.goFetchFAQDataSource(sectionId);
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_search_faq");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_rv_faq_search");
    }

    @Override
    public void refreshList(List<FaqListEntity> displayFaqList) {
        if (!ListUtil.isListEmpty(displayFaqList)) {
            mAdapter.update(displayFaqList);
        } else {
            showEmpty();
        }
    }

}
