package net.aihelp.ui.adapter.cs.user;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UserVideoAdapter extends BaseMsgAdapter {

    private final ExecutorService mExecutorService;

    public UserVideoAdapter(Context context) {
        super(context);
        mExecutorService = Executors.newCachedThreadPool();
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_video");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_USER_VIDEO;
    }

    @Override
    public void convert(final ViewHolder holder, final ConversationMsg conversationMsg, final int position) {

        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

        holder.setVisible(getViewId("aihelp_iv_msg_retry"), false);

        if (conversationMsg.getVideoThumbnail() != null) {
            loadUpImageView(holder, conversationMsg, position);
        } else {
            if (mExecutorService != null) mExecutorService.execute(new Runnable() {
                @Override
                public void run() {
                    conversationMsg.prepareVideoThumbnail();

                    // java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
                    if (mContext instanceof Activity && ((Activity) mContext).isFinishing()) {
                        TLog.e("You cannot start a load for a destroyed activity, interrupt current invoke.");
                        return;
                    }

                    ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            loadUpImageView(holder, conversationMsg, position);
                        }
                    });
                }
            });
        }

    }

    private void loadUpImageView(ViewHolder holder, final ConversationMsg conversationMsg, final int position) {
        final AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
        imageView.loadIntoImageView(mContext, conversationMsg);

        if (conversationMsg.getMsgStatus() == ConversationMsg.STATUS_RETRY) {
            holder.setVisible(getViewId("aihelp_iv_msg_retry"), true);
            holder.setOnClickListener(getViewId("aihelp_iv_msg_retry"), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null) {
                        mWrapper.onRetrySendingMessage(position, conversationMsg);
                    }
                }
            });
            return;
        }

        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
                ImageViewer.getDefault(mContext).updateVideoResource(conversationMsg.getVideoThumbnail(), conversationMsg.getMsgContent()).show();
            }
        });
    }

}
