package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageButton;


public class UserTextAdapter extends BaseMsgAdapter {

    public UserTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_USER_TEXT ||
                item.getMsgType() == ConversationMsg.TYPE_USER_TEXT_BOT;
    }

    @Override
    public void convert(final ViewHolder holder, final ConversationMsg s, final int position) {
        updateMsgSendingStatus(holder, s.getMsgContent(), s.getMsgStatus());
        holder.setOnClickListener(getViewId("aihelp_iv_msg_retry"), new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mWrapper != null) {
                    mWrapper.onRetrySendingMessage(position, s);
                }
            }
        });

    }

    private void updateMsgSendingStatus(ViewHolder holder, String msgContent, int status) {

        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

        TextView msgView = holder.getView(getViewId("aihelp_admin_message_text"));
        msgView.setText(getUrlSupportedText(msgContent));
        msgView.setTextColor(Color.WHITE);
        msgView.setMovementMethod(LinkMovementMethod.getInstance());
        msgView.setMaxWidth(Math.max(getRightfulMaxWidth(holder), dip2px(mContext, 200)));
        msgView.setBackground(getUserBackgroundDrawable(isCurrentRtl));

        AppCompatImageButton retryButton = holder.getView(getViewId("aihelp_iv_msg_retry"));

        switch (status) {
            case ConversationMsg.STATUS_SUCCESS:
                holder.setVisible(getViewId("aihelp_iv_msg_sending"), false);
                holder.setVisible(getViewId("aihelp_iv_msg_retry"), false);
                break;
            case ConversationMsg.STATUS_SENDING:
                holder.setVisible(getViewId("aihelp_iv_msg_sending"), true);
                holder.setVisible(getViewId("aihelp_iv_msg_retry"), false);
                break;
            case ConversationMsg.STATUS_RETRY:
                holder.setVisible(getViewId("aihelp_iv_msg_sending"), false);
                holder.setVisible(getViewId("aihelp_iv_msg_retry"), true);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                break;
            case ConversationMsg.STATUS_FAILURE:
                holder.setVisible(getViewId("aihelp_iv_msg_sending"), false);
                holder.setVisible(getViewId("aihelp_iv_msg_retry"), true);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_failed"));
                break;
        }
    }

    private int getRightfulMaxWidth(ViewHolder holder) {
        ImageView ivPortrait = holder.getView(getViewId("aihelp_iv_portrait"));
        TextView tvMsg = holder.getView(getViewId("aihelp_admin_message_text"));
        return Styles.getScreenWidth(mContext) - (dip2px(mContext, 39) +
                ((ViewGroup.MarginLayoutParams) ivPortrait.getLayoutParams()).rightMargin +
                ((ViewGroup.MarginLayoutParams) tvMsg.getLayoutParams()).rightMargin) * 2;
    }

    private Drawable getUserBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15)
                : Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15);
    }

}
