package net.aihelp.ui.adapter.cs.admin;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class AdminRichTextAdapter extends BaseMsgAdapter {

    public AdminRichTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_admin");
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_ADMIN_RICHTEXT;
    }

    @Override
    public void convert(ViewHolder holder, ConversationMsg msg, int position) {

        LinearLayout llContainer = holder.getView(getViewId("aihelp_admin_message_container"));
        llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
        llContainer.removeAllViews();

        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_admin");

        Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")), msg.getNickname(),
                CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(msg.getNickname()));

        convertSupportTextMsg(holder, llContainer, msg);

    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, ConversationMsg msg) {
        holder.setVisible(getViewId("aihelp_tv_nickname"), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(msg.getNickname()));
        holder.setText(getViewId("aihelp_tv_nickname"), msg.getNickname());
        holder.setTextColor(getViewId("aihelp_tv_nickname"), Color.parseColor(CustomConfig.CommonSetting.textColor));
        container.addView(getRichTextMsg(msg.getMsgContent()));
    }

    private void convertElvaBotTextMsg(ViewGroup container, ElvaBotMsg botMsg) {

    }

}
