package net.aihelp.ui.adapter.cs;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.text.style.UnderlineSpan;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.BuildConfig;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.storyline.BotTag;
import net.aihelp.data.model.cs.storyline.BotUrl;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;

import net.aihelp.ui.adapter.MessageListAdapter;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.URLEncodeUtil;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseMsgAdapter implements ItemViewDelegate<ConversationMsg> {

    private static final String REGEX_IMAGE = "(http:|https:)(//)((?!\").)*?.(PNG|png|JPG|jpg|JPEG|jpeg)";
    //    private static final String REGEX_FORM = "(http:|https:)(//)((?!\").)*?((?=(\\s?http))|\\.(PNG|png|JPG|jpg|JPEG|jpeg))|(http:|https:)(//)((?!\").)*";
    private static final String REGEX_RICH_TEXT = "(http:|https:)(//)\\S*?((?=\\s+http)|\\.(PNG|png|JPG|jpg|JPEG|jpeg))|(http:|https:)(//)((?!\").)*";

    protected final Context mContext;
    protected MessageListAdapter.OnClickedListenerWrapper mWrapper;
    protected List<ConversationMsg> dataList = new ArrayList<>();

    protected boolean isCurrentRtl;

    public BaseMsgAdapter(Context context) {
        this.mContext = context;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            isCurrentRtl = context.getResources()
                    .getConfiguration().getLayoutDirection() == View.LAYOUT_DIRECTION_RTL;
        }
    }

    protected Drawable getAdminBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15) :
                Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15);
    }

    public void setOnClickedListenerWrapper(MessageListAdapter.OnClickedListenerWrapper mWrapper) {
        this.mWrapper = mWrapper;
    }

    protected TextView getMsg(String botMsg) {
        if (!TextUtils.isEmpty(botMsg) && botMsg.contains("&formUrlTitle=")) {
            Matcher matcher = Pattern.compile("(http:|https:)(//)((?!\").)*?(&formUrlTitle=)*?").matcher(botMsg);
            if (matcher.matches()) {
                botMsg = botMsg + "&fromSdk=1&isCustom=1";
                Matcher subMatcher = Pattern.compile("(?<=(formUrlTitle=)).*(?=(&fromSdk=1&isCustom=1))").matcher(botMsg);
                String formTitle = botMsg;
                if (subMatcher.find()) {
                    formTitle = URLEncodeUtil.decode(subMatcher.group());
                }
                return getUrl(new BotUrl(formTitle, botMsg), mWrapper);
            }
        }

        TextView textView = new TextView(mContext);
        textView.setTextSize(14);
        textView.setLineSpacing(dip2px(mContext, 3), 1.0f);
        textView.setTextColor(Color.parseColor(CustomConfig.CommonSetting.textColor));
        textView.setTextIsSelectable(true);

        boolean isMIUI12 = ("XiaoMi".equalsIgnoreCase(Build.MANUFACTURER) || "RedMi".equalsIgnoreCase(Build.MANUFACTURER)) &&
                Build.VERSION.SDK_INT <= Build.VERSION_CODES.R;
        boolean isSamsungOreo = "samsung".equalsIgnoreCase(Build.MANUFACTURER) && Build.VERSION.SDK_INT <= Build.VERSION_CODES.O;

        if (isMIUI12 || isSamsungOreo) {
            textView.setText(botMsg);
        } else {
            textView.setText(getUrlSupportedText(botMsg));
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }

        return textView;
    }

    /**
     * 加载富文本消息，有可能同时出现：多个图片、多个表单以及多段文本
     *
     * @param msg
     * @return
     */
    protected View getRichTextMsg(final String msg) {

        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.setGravity(Gravity.START);

        try {
            LinkedList<Integer> urlIndexList = new LinkedList<>();
            urlIndexList.add(0);

            // 使用正则匹配返回的信息，里边可能有表单、图片、普通文字等，并将匹配到的位置信息存到数组中
            Matcher formMatcher = Pattern.compile(REGEX_RICH_TEXT).matcher(msg);
            while (formMatcher.find()) {
                urlIndexList.add(formMatcher.start());
                urlIndexList.add(formMatcher.end());
            }

            if (urlIndexList.getLast() != msg.length()) {
                urlIndexList.add(msg.length());
            }

            for (int i = 0; i < urlIndexList.size() - 1; i++) {
                final String urlOrRawText = msg.substring(urlIndexList.get(i), urlIndexList.get(i + 1)).trim();
                // 因为 addView 的时候自然会换行，所以不需要处理文本中自带的换行符
                if (Pattern.compile("\\s*?").matcher(urlOrRawText).matches()) continue;
                if (Pattern.compile(REGEX_IMAGE).matcher(urlOrRawText).matches()) {
                    final ImageView imageView = new ImageView(mContext);
                    imageView.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                    imageView.setAdjustViewBounds(true);
                    Picasso.get().load(urlOrRawText).into(imageView);
                    imageView.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            ImageViewer imageViewer = ImageViewer.getDefault(mContext);
                            imageViewer.updateImageResource(urlOrRawText);
                            imageViewer.show();
                        }
                    });
                    layout.addView(imageView);
                } else {
//                    TextView measureTextView = getMsg(urlOrRawText);
//                    measureTextView.measure(0, 0); // measure 之后 selectable 属性会失效且无法恢复
//                    int maxTextWidth = Styles.getScreenWidth(mContext) - (dip2px(mContext, 140));
//                    int width = Math.min(measureTextView.getMeasuredWidth(), maxTextWidth);
//                    TextView textView = getMsg(urlOrRawText);
//                    textView.setLayoutParams(new LinearLayout.LayoutParams(width, ViewGroup.LayoutParams.WRAP_CONTENT));
//                    layout.addView(textView);

                    TextView textView = getMsg(urlOrRawText);
                    textView.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                    layout.addView(textView);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return layout;
    }

    protected TextView getUrl(final BotUrl botUrl, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(mContext);
        textView.setText(String.format("%s", botUrl.getUrlTitle()));
        textView.setTextSize(14);
        textView.setClickable(true);
        textView.setTextColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String urlAddress = botUrl.getUrlAddress();
                if (!TextUtils.isEmpty(urlAddress)) {
                    if (urlAddress.contains("js-bridge=enable") && Const.sOnSpecificUrlClickedListener != null) {
                        Const.sOnSpecificUrlClickedListener.onSpecificUrlClicked(urlAddress);
                    } else if (wrapper != null && FastClickValidator.validate()) {
                        wrapper.onUrlClicked(getFormattedUrl(urlAddress));
                    }
                }
            }
        });
        textView.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 5));
        return textView;
    }

    protected TextView getFormUrl(final ElvaBotMsg botMsg, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(mContext);
        textView.setText(String.format("%s", botMsg.getBotFormUrl().getFormTitle()));
        textView.setTextSize(14);
        textView.setClickable(true);
        textView.setTextColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String formUrl = getFormattedFormUrl(botMsg);
                if (wrapper != null && FastClickValidator.validate()) {
                    wrapper.onFormUrlClicked(botMsg.getTimeStamp(), formUrl);
                }
            }
        });
        textView.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 5));
        return textView;
    }

    protected TextView getBotOrderInfo(final ElvaBotMsg botMsg, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(mContext);
        textView.setText(String.format("%s", botMsg.getBotOrderInfo().getName()));
        textView.setTextSize(14);
        textView.setClickable(true);
        textView.setTextColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (wrapper != null && FastClickValidator.validate()) {
                    wrapper.onOrderInfoClicked(botMsg.getBotOrderInfo());
                }
            }
        });
        textView.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 5));
        return textView;
    }

    protected TextView getAction(int index, final String actionName, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        TextView textView = new TextView(mContext);
        textView.setText(String.format("%s %s", "·", actionName));
        textView.setTextSize(14);
        textView.setClickable(true);
        textView.setTextColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (wrapper != null && FastClickValidator.validate()
                        && !TextUtils.isEmpty(actionName) && !TextUtils.isEmpty(actionName.trim())) {
                    wrapper.onActionClicked(actionName);
                }
            }
        });
        textView.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 5));
        return textView;
    }

    protected View getFAQLayout(final ElvaBotMsg botMsg, final MessageListAdapter.OnClickedListenerWrapper wrapper) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        if (botMsg.isHasUrl()) {
            View.OnClickListener onClickListener = new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (wrapper != null && FastClickValidator.validate()) {
                        BotUrl botUrl = botMsg.getBotUrl();
                        if (botUrl != null) {
                            String url = getFormattedUrl(botUrl.getUrlAddress());
                            if (!url.contains("isCustom=1")) url = url + "&isCustom=1";
                            botUrl.setUrlAddress(url);
                        }
                        wrapper.onFaqClicked(botMsg);
                        StatisticHelper.whenBotFAQClicked(botMsg);
                        botMsg.setFaqViewed(true);
                    }
                }
            };

            TextView faqContent = new TextView(mContext);
            faqContent.setTextSize(15);
            faqContent.setLineSpacing(dip2px(mContext, 3), 1.0f);
            faqContent.setTextColor(Color.parseColor(CustomConfig.CommonSetting.textColor));
            faqContent.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 12));
            faqContent.setText(botMsg.getTemplate());
            layout.addView(faqContent);

            TextView tvShowMore = new TextView(mContext);
            tvShowMore.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
            tvShowMore.setTextSize(15);
            tvShowMore.setGravity(Gravity.CENTER);
            tvShowMore.setLineSpacing(dip2px(mContext, 3), 1.0f);
            tvShowMore.setTextColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
            tvShowMore.setPadding(0, dip2px(mContext, 7), 0, dip2px(mContext, 7));
            tvShowMore.setText(ResResolver.getString("aihelp_view_details"));
            tvShowMore.setOnClickListener(onClickListener);
            layout.addView(tvShowMore);
        }

        if (botMsg.isHasFormUrl()) {

            View divider = new View(mContext);
            divider.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f));
            divider.setLayoutParams(new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, dip2px(mContext, 1)));
            divider.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 5));
            layout.addView(divider);

            TextView formUrl = getFormUrl(botMsg, mWrapper);
            formUrl.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
            formUrl.setPadding(0, dip2px(mContext, 12), 0, dip2px(mContext, 5));
            layout.addView(formUrl);
        }

        return layout;
    }

    private String getFormattedUrl(String urlAddress) {
        if (urlAddress.contains("auto-append=enable")) {
            String deviceModel = "";
            if (Build.MANUFACTURER != null && Build.MODEL != null) {
                deviceModel = String.format("%s %s", Build.MANUFACTURER, Build.MODEL);
            }
            return String.format("%s&userId=%s&serverId=%s&language=%s&country=%s&model=%s&deviceId=%s&sign=%s",
                    urlAddress.replace("escaped=yes", "escaped=no"),
                    UserProfile.USER_ID,
                    UserProfile.SERVER_ID,
                    Const.ORIGINAL_LANGUAGE,
                    DeviceInfoUtil.getInstance().getSimCountryIso(),
                    deviceModel.replace(" ", "-"),
                    DeviceInfoUtil.getInstance().getDeviceIdFromCustomData(),
                    HttpConfig.md5(String.format("userId=%s&serverId=%s&salt=AIHelp", UserProfile.USER_ID, UserProfile.SERVER_ID))
            );
        }
        return urlAddress;
    }

    private String getFormattedFormUrl(ElvaBotMsg botMsg) {
        return String.format("%s&appId=%s&userId=%s&serverId=%s&platform=%s&sdkVersion=%s&isTicket=1&%s&hasPermission=%s&fromSdk=1&isCustom=1",
                botMsg.getBotFormUrl().getFormAddress(),
                Const.APP_ID,
                UserProfile.USER_ID,
                UserProfile.SERVER_ID,
                BuildConfig.SDK_PLATFORM,
                BuildConfig.SDK_VERSION,
                getTagParams(botMsg),
                0);
    }

    private String getTagParams(ElvaBotMsg botMsg) {
        StringBuilder tagId = new StringBuilder();
        StringBuilder tagName = new StringBuilder();
        if (botMsg.isHasTag()) {
            List<BotTag> tagList = botMsg.getBotTagList();
            for (int i = 0; i < tagList.size(); i++) {
                tagId.append(tagList.get(i).getTagId());
                if (i != tagList.size() - 1) {
                    tagId.append(",");
                }

                tagName.append(tagList.get(i).getTagName());
                if (i != tagList.size() - 1) {
                    tagName.append(",");
                }
            }
        }
        return String.format("tagId=%s&tagName=%s", tagId.toString(), tagName.toString());
    }

    @Override
    public void onDataSourceUpdated(List<ConversationMsg> data) {
        dataList.clear();
        dataList.addAll(data);
    }

    protected SpannableStringBuilder getUrlSupportedText(String msg) {
        if (TextUtils.isEmpty(msg)) return new SpannableStringBuilder("");

        msg = msg.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
        msg = "<span style=\"word-wrap:break-word\">" + msg.replace("\n", "<br/>") + "</span>";
        Spanned htmlMsg = Html.fromHtml(msg);
        SpannableStringBuilder ssb = new SpannableStringBuilder(htmlMsg);

        // 匹配多个 https 连接
        Pattern pattern = Pattern.compile("(http|https):\\/\\/[\\w\\-_]+(\\.[\\w\\-_]+)+([\\w\\-\\.\\|,@?^=%&amp;:/~\\+#]*[\\w\\-\\@?^=%&amp;/~\\+\\|#])?");
        Matcher matcher = pattern.matcher(ssb);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            final String urlStr = matcher.group();

            ClickableSpan clickableSpan = new ClickableSpan() {
                @Override
                public void onClick(View view) {
                    if (mWrapper != null && FastClickValidator.validate()) {
                        mWrapper.onUrlClicked(urlStr);
                    }
                }

                @Override
                public void updateDrawState(TextPaint dp) {
                    dp.setColor(Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
                }
            };
            ssb.setSpan(clickableSpan, start, end, Spannable.SPAN_EXCLUSIVE_INCLUSIVE);
            ssb.setSpan(new UnderlineSpan(), start, end, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
        }

        // 匹配 a 标签
//        URLSpan[] urls = ssb.getSpans(0, htmlMsg.length(), URLSpan.class);
//        for (final URLSpan span : urls) {
//            int start = ssb.getSpanStart(span);
//            int end = ssb.getSpanEnd(span);
//            ClickableSpan clickableSpan = new ClickableSpan() {
//                @Override
//                public void onClick(View view) {
//                    if (mWrapper != null) {
//                        mWrapper.onUrlClicked(span.getURL());
//                    }
//                }
//
//                @Override
//                public void updateDrawState(TextPaint dp) {
//                    dp.setColor(Color.parseColor("#5C7EFF"));
//                }
//            };
//            ssb.setSpan(clickableSpan, start, end, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
//            ssb.setSpan(new UnderlineSpan(), start, end, Spanned.SPAN_EXCLUSIVE_INCLUSIVE);
//        }

        return ssb;
    }

    protected int getViewId(String name) {
        return ResResolver.getViewId(name);
    }

    protected int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * density + 0.5);
    }

}
