package net.aihelp.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;


import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.image.Picasso;

import net.aihelp.data.localize.data.OperateHelper;
import net.aihelp.data.model.op.OperateArticle;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class OperateListAdapter extends CommonAdapter<OperateArticle> {

    private OnOperationFaqClickedListener mListener;

    public OperateListAdapter(Context context, OnOperationFaqClickedListener listener) {
        super(context);
        this.mListener = listener;
    }

    @Override
    protected int itemLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_item_op_list");
    }

    @Override
    protected void convert(ViewHolder holder, final OperateArticle faq, final int position) {

        String faqImageUrl = DomainSupportHelper.correctDomain(faq.getFaqImageUrl());
        Picasso.get().load(faqImageUrl).into((ImageView) holder.getView(ResResolver.getViewId("aihelp_iv_portrait")));

        TextView tvTitle = holder.getView(ResResolver.getViewId("aihelp_tv_op_title"));
        tvTitle.setText(faq.getFaqTitle());
        tvTitle.setTextColor(Color.parseColor(CustomConfig.CommonSetting.textColor));

        TextView tvTime = holder.getView(ResResolver.getViewId("aihelp_tv_time"));
        tvTime.setText(faq.getFaqUpdateDate());
        tvTime.setTextColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5f));

        ImageView ivArrow = holder.getView(ResResolver.getViewId("aihelp_iv_arrow"));
        Styles.reRenderImageView(ivArrow, "aihelp_svg_ic_arrow_right",
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5f));

        holder.setVisible(ResResolver.getViewId("aihelp_v_unread_status"),
                Const.sOperationUnreadListener != null && OperateHelper.INSTANCE.isArticleUnread(faq.getFaqMainId()));

        holder.getConvertView().setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    // If current faq has unread notification, reset it after the click event.
                    if (OperateHelper.INSTANCE.isArticleUnread(faq.getFaqMainId())) {
                        OperateHelper.INSTANCE.updateOperateFaqUnreadStatus(faq.getFaqMainId());
                        notifyItemChanged(position);
                    }
                    mListener.onOperationFaqClicked(faq.getFaqMainId());
                }
            }
        });

    }

    public interface OnOperationFaqClickedListener {
        void onOperationFaqClicked(String faqId);
    }

}
