package net.aihelp.exception;

import android.util.Log;

import net.aihelp.core.util.logger.AIHelpLogger;

public class AIHelpCrashHandler  {

    private static final CharSequence AIHELP_PACKAGE_NAME = "net.aihelp";

    public static void init() {
        final java.lang.Thread.UncaughtExceptionHandler defaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler() {
            public void uncaughtException(Thread thread, Throwable ex) {
                if (isCrashedByAIHelp(ex)) {
                    AIHelpLogger.fatal(ex.getMessage(), ex);
                }
                if (defaultUncaughtExceptionHandler != null) {
                    defaultUncaughtExceptionHandler.uncaughtException(thread, ex);
                }
            }
        });
    }

    static boolean isCrashedByAIHelp(Throwable throwable) {
        if (throwable == null) {
            return false;
        } else {
            String stackTrace = Log.getStackTraceString(throwable);
            return stackTrace.contains(AIHELP_PACKAGE_NAME);
        }
    }

}
