package net.aihelp.data.model.faq;


import android.text.TextUtils;

public class FaqContentEntity {

    public static final int TYPE_MAIN_ID = 1;
    public static final int TYPE_CONTENT_ID = 2;
    public static final int TYPE_DISPLAY_ID = 3;

    public static final int FAQ_DISPLAY_SECTION = 1;
    public static final int FAQ_DISPLAY_SUB_SECTION = 2;
    public static final int FAQ_DISPLAY_QUESTION_LIST = 3;
    public static final int FAQ_DISPLAY_SEARCH = 4;

    private int faqType;
    private String sectionId;
    private String sectionName;
    private String sectionBId;
    private String sectionBName;

    private String secId;
    private String secName;
    private String faqTitle;
    private String faqKeywords;
    private String faqMainId;
    private String faqDisplayId;
    private String faqContentId;
    private String faqContent;
    private String faqNoHtmlContent;
    private int isHelpful;
    private String searchTerm;
    private String similarQuestions;

    public FaqContentEntity() {
    }

    public FaqContentEntity(String secId, String faqTitle, String faqKeywords, String faqMainId, String faqDisplayId,
                            String faqContentId, String faqContent, int isHelpful, String searchTerm) {
        this.secId = secId;
        this.faqTitle = faqTitle;
        this.faqKeywords = faqKeywords;
        this.faqMainId = faqMainId;
        this.faqDisplayId = faqDisplayId;
        this.faqContentId = faqContentId;
        this.faqContent = faqContent;
        this.isHelpful = isHelpful;
        this.searchTerm = searchTerm;
    }

    public String getSectionId() {
        return sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public String getSectionBId() {
        return sectionBId;
    }

    public void setSectionBId(String sectionBId) {
        this.sectionBId = sectionBId;
    }

    public String getSectionBName() {
        return sectionBName;
    }

    public void setSectionBName(String sectionBName) {
        this.sectionBName = sectionBName;
    }

    public String getFaqDisplayId() {
        return faqDisplayId;
    }

    public void setFaqDisplayId(String faqDisplayId) {
        this.faqDisplayId = faqDisplayId;
    }

    public String getFaqContentId() {
        return faqContentId;
    }

    public void setFaqContentId(String faqContentId) {
        this.faqContentId = faqContentId;
    }

    public int isHelpful() {
        return isHelpful;
    }

    public void setHelpful(int helpful) {
        isHelpful = helpful;
    }

    public String getSearchTerm() {
        return searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public void clearSearchTerms() {
        this.searchTerm = null;
    }

    public void updateSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public String getFaqNoHtmlContent() {
        return faqNoHtmlContent;
    }

    public void setFaqNoHtmlContent(String faqNoHtmlContent) {
        this.faqNoHtmlContent = faqNoHtmlContent;
    }

    public String getSecId() {
        return secId;
    }

    public void setSecId(String secId) {
        this.secId = secId;
    }

    public String getFaqTitle() {
        if (TextUtils.isEmpty(faqTitle)) {
            return "";
        }
        return faqTitle;
    }

    public void setFaqTitle(String faqTitle) {
        this.faqTitle = faqTitle;
    }

    public String getFaqMainId() {
        return faqMainId;
    }

    public void setFaqMainId(String faqMainId) {
        this.faqMainId = faqMainId;
    }

    public String getFaqContent() {
        return faqContent;
    }

    public void setFaqContent(String faqContent) {
        this.faqContent = faqContent;
    }

    public String getFaqKeywords() {
        return faqKeywords;
    }

    public void setFaqKeywords(String faqKeywords) {
        this.faqKeywords = faqKeywords;
    }

    public int getIsHelpful() {
        return isHelpful;
    }

    public void setIsHelpful(int isHelpful) {
        this.isHelpful = isHelpful;
    }

    public String getSimilarQuestions() {
        if (TextUtils.isEmpty(similarQuestions)) {
            return "";
        }
        return similarQuestions;
    }

    public void setSimilarQuestions(String similarQuestions) {
        this.similarQuestions = similarQuestions;
    }

    public int getFaqType() {
        return faqType;
    }

    public void setFaqType(int faqType) {
        this.faqType = faqType;
    }

    public String getSecName() {
        return secName;
    }

    public void setSecName(String secName) {
        this.secName = secName;
    }
}
