package net.aihelp.data.local;

import android.content.Context;

import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.faq.FaqListEntity;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class FaqRepository extends AbsRepository {

    public FaqRepository(Context context) {
        super(context);
    }

    public boolean shouldShowQuestionFooter(String faqId) {
        return FaqHelper.INSTANCE.shouldShowQuestionFooter(faqId);
    }

    public boolean checkWhetherHasSubSection(String sectionId) {
        return FaqHelper.INSTANCE.hasSubsections(sectionId);
    }

    public ArrayList<FaqListEntity> getMatchedFaqList(String query) {
        JSONArray sourceNotifications = FaqHelper.INSTANCE.getRawNotification();
        JSONArray sourceHotTopics = FaqHelper.INSTANCE.getRawHotTopics();
        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();

        ArrayList<FaqListEntity> matchedFaqList = new ArrayList<>();

        StringBuilder addedFaqs = new StringBuilder();
        matchedFaqList.addAll(iteratorFaqList(sourceNotifications, query, addedFaqs));
        matchedFaqList.addAll(iteratorFaqList(sourceHotTopics, query, addedFaqs));
        matchedFaqList.addAll(iteratorFaqList(sourceFaqs, query, addedFaqs));

        return matchedFaqList;
    }

    public List<FaqListEntity> iteratorFaqList(JSONArray sourceArray, String query, StringBuilder addedFaqs) {
        ArrayList<FaqListEntity> titleMatchedList = new ArrayList<>();
        ArrayList<FaqListEntity> contentMatchedList = new ArrayList<>();

        if (sourceArray != null && sourceArray.length() > 0) {
            for (int i = 0; i < sourceArray.length(); i++) {
                JSONObject faq = JsonHelper.getJsonObject(sourceArray, i);
                String faqMainId = faq.optString("kmMainid");
                String faqTitle = faq.optString("question");
                String faqContent = faq.optString("noHtmlContent");

                if (faqTitle.toLowerCase().contains(query.toLowerCase())) {
                    if (!addedFaqs.toString().contains(faqMainId)) {
                        FaqListEntity matched = new FaqListEntity(FaqListEntity.FAQ_DISPLAY_SEARCH, faqMainId, faqTitle, query);
                        titleMatchedList.add(matched);
                        addedFaqs.append(String.format("%s,", faqMainId));
                    }
                    continue;
                }

                if (faqContent.toLowerCase().contains(query.toLowerCase())) {
                    if (!addedFaqs.toString().contains(faqMainId)) {
                        FaqListEntity matched = new FaqListEntity(FaqListEntity.FAQ_DISPLAY_SEARCH, faqMainId, faqTitle, query);
                        contentMatchedList.add(matched);
                        addedFaqs.append(String.format("%s,", faqMainId));
                    }
                }
            }
        }
        ArrayList<FaqListEntity> matchedFaqList = new ArrayList<>();
        matchedFaqList.addAll(contentMatchedList);
        matchedFaqList.addAll(0, titleMatchedList);
        return matchedFaqList;
    }

}
