package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Context;
import net.aihelp.core.util.elva.Match;
import net.aihelp.core.util.elva.text.Response;

public class That extends TemplateElement {

    private static final String[] STRING_ARRAY = {};
    private int responseIndex = 1, sentenceIndex = 1;

    public That(Attributes attributes) {
        String value = attributes.getValue(0);
        if (value == null) {
            return;
        }
        String[] indexes = value.split(",");
        responseIndex = Integer.parseInt(indexes[0].trim());
        if (indexes.length > 1) {
            sentenceIndex = Integer.parseInt(indexes[1].trim());
        }
    }

    public That(Object... children) {
        super(children);
    }

    public That(int responseIndex, int sentenceIndex) {
        this.responseIndex = responseIndex;
        this.sentenceIndex = sentenceIndex;
    }

    public String[] elements() {
        TemplateElement[] children = getChildren();
        List<String> elements = new LinkedList<String>();
        try {
            for (int i = 0, n = children.length; i < n; i++) {
                String text = children[i].toString();
                text = text.trim();
                elements.addAll(Arrays.asList(text.split(" ")));
            }
        } catch (Exception e) {
            // ignored
        }
        return elements.toArray(STRING_ARRAY);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof That)) {
            return false;
        }
        That compared = (That) obj;
        return (responseIndex == compared.responseIndex &&
                sentenceIndex == compared.sentenceIndex);
    }

    public int hashCode() {
        return responseIndex + sentenceIndex;
    }

    public String process(Match match) {
        if (match == null) {
            return "";
        }
        ElvaBot bot = match.getCallback();
        Context context = bot.getContext();
        Response response = context.getResponses(responseIndex - 1);
        return response.getSentences(sentenceIndex - 1).trimOriginal();
    }

    public String toString() {
        if (children().size() == 0) {
            return "<that index=\"" + responseIndex + ", " + sentenceIndex + "\"/>";
        } else {
            StringBuilder builder = new StringBuilder("<that>");
            for (TemplateElement element : children()) {
                builder.append(element);
            }
            builder.append("</that>");
            return builder.toString();
        }
    }
}