package net.aihelp.core.util.elva.aiml;

import org.xml.sax.Attributes;

import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.Match;

public class Srai extends TemplateElement {

    private String id;
    private String type;
    private String externalName;
    private String url;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getExternalName() {
        return externalName;
    }

    public void setExternalName(String externalName) {
        this.externalName = externalName;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Srai() {
    }

    public Srai(Attributes attributes) {
        id = attributes.getValue("id");
        type = attributes.getValue("type");
        externalName = attributes.getValue("externalName");
        url = attributes.getValue("url");
    }

    public Srai(String id, String type, String externalName, String url, Object... elements) {
        super(elements);
        this.id = id;
        this.type = type;
        this.externalName = externalName;
        this.url = url;
    }

    private boolean isEquals(Object comparing, Object compared) {
        return (comparing == null ? compared == null : comparing.equals(compared));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Srai compared = (Srai) obj;
        return (isEquals(id, compared.id) && isEquals(type, compared.type)
                && isEquals(externalName, compared.externalName) && isEquals(url, compared.url));
    }

    public String process(Match match) {
        try {
            return String.format("<srai id='%s' type='%s' externalName='%s' url='%s'></srai>",
                    id.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"),
                    type.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"),
                    externalName.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"),
                    url.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;"));
        } catch (NullPointerException e) {
            return "";
        }
    }

}