package net.aihelp.core.ui.loading.helper;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import net.aihelp.utils.TLog;

import java.lang.ref.WeakReference;

public class VaryViewHelper {

    private WeakReference<Activity> mActivityRef;
    private View mOriginView;
    private ViewGroup mParentView;
    private int mTargetViewIndex = -1;
    private ViewGroup.LayoutParams mOriginViewParams;

    VaryViewHelper(View view) {
        if (view.getContext() instanceof Activity) {
            mActivityRef = new WeakReference<>((Activity) view.getContext());
        }
        this.mOriginView = view;
        prepareOriginViewCache();
    }

    private void prepareOriginViewCache() {
        mOriginViewParams = mOriginView.getLayoutParams();
        mParentView = (ViewGroup) mOriginView.getParent();
        if (mParentView != null) {
            for (int index = 0; index < mParentView.getChildCount(); index++) {
                if (mOriginView == mParentView.getChildAt(index)) {
                    mTargetViewIndex = index;
                    break;
                }
            }
        }
    }

    void showLayout(View replaceView) {
        if (mActivityRef.get() != null && !mActivityRef.get().isFinishing()) {
            if (mParentView == null || mParentView.getChildAt(mTargetViewIndex) == replaceView) {
                TLog.e("mParentView == null -- > " + (mParentView == null));
                TLog.e("mParentView.getChildAt(mTargetViewIndex) == replaceView -- > " + (mParentView.getChildAt(mTargetViewIndex) == replaceView));
                return;
            }
            mParentView.removeViewAt(mTargetViewIndex);
            mParentView.addView(replaceView, mTargetViewIndex, mOriginViewParams);
        }
    }

    void restoreView() {
        if (mActivityRef.get() != null && !mActivityRef.get().isFinishing()) {
            showLayout(mOriginView);
        }
    }

    public View inflate(int layoutId) {
        return LayoutInflater.from(mOriginView.getContext()).inflate(layoutId, null);
    }

    public Context getContext() {
        return mOriginView.getContext();
    }

    public View getTargetView() {
        return mOriginView;
    }

}
