package net.aihelp.core.net.mqtt.hawtdispatch.internal.pool;

import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.NioManager;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.ThreadDispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.WorkerThread;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;

import static java.lang.String.format;

/**
 */
public class SimpleThread extends WorkerThread {

    private SimplePool pool;
    private ThreadDispatchQueue threadQueue;
    private final NioManager nioManager;

    public SimpleThread(SimplePool pool) throws IOException {
        super(pool.group, pool.name);
        this.pool = pool;
        this.nioManager = new NioManager();
        this.threadQueue = new ThreadDispatchQueue(pool.globalQueue, this);
    }

    @Override
    public ThreadDispatchQueue getDispatchQueue() {
        return threadQueue;
    }
    @Override
    public void unpark() {
        nioManager.wakeupIfSelecting();
    }

    @Override
    public NioManager getNioManager() {
        return nioManager;
    }

    @Override
    public void run() {
        debug("run start");
        try {
            ConcurrentLinkedQueue<Task> sharedQueue = pool.tasks;
            while(!pool.shutdown) {

                Task task = threadQueue.poll();
                if( task==null ) {
                    task = sharedQueue.poll();
                    if( task==null ) {
                        task = threadQueue.getSourceQueue().poll();
                    }
                }

                if( task == null ) {
                    pool.park(this);
                } else {
                    task.run();
                }
            }
        } finally {
            debug("run end");
        }
    }


    public static final boolean DEBUG = false;
    protected void debug(String str, Object... args) {
        if (DEBUG) {
            System.out.println(format("[DEBUG] SimpleThread %s: %s", getName(), format(str, args)));
        }
    }
    protected void debug(Throwable thrown, String str, Object... args) {
        if (DEBUG) {
            if (str != null) {
                debug(str, args);
            }
            if (thrown != null) {
                thrown.printStackTrace();
            }
        }
    }

}
