package net.aihelp.core.net.json;

import android.text.TextUtils;

import net.aihelp.core.util.logger.AIHelpLogger;

import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JsonHelper {

    public static <T> T toJavaObject(String jsonString, Type type) {
        try {
            String clazzName = type.toString().split(" ")[1].trim();
            Class<?> typeClass = Class.forName(clazzName);
            return (T) toJavaObject(jsonString, typeClass);
        } catch (Throwable e) {
            e.printStackTrace();
            AIHelpLogger.error("JsonHelper toJavaObject#30", e);
        }
        return null;
    }

    public static <T> T toJavaObject(String jsonString, Class<T> clazz) {
        if (TextUtils.isEmpty(jsonString)) return null;
        if (clazz == String.class || clazz == Integer.class || clazz == Double.class || clazz == Float.class) {
            return (T) jsonString;
        }

        try {
            T returnObject = clazz.newInstance();
            JSONObject jsonObject = new JSONObject(jsonString);
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);

                Object optObject = jsonObject.opt(field.getName());
                if (optObject instanceof JSONObject) {
                    field.set(returnObject, toJavaObject(optObject.toString(), field.getType()));
                } else if (optObject instanceof JSONArray && "List".equals(field.getType().getSimpleName())) {
                    GenericType genericType = field.getAnnotation(GenericType.class);
                    if (genericType != null) {
                        field.set(returnObject, toJavaList(optObject.toString(), genericType.value()));
                    }
                } else {
                    if ("String".equals(field.getType().getSimpleName())) {
                        field.set(returnObject, optObject != null && optObject != JSONObject.NULL ? String.valueOf(optObject) : "");
                    } else if (optObject != null && optObject != JSONObject.NULL) {
                        field.set(returnObject, optObject);
                    }
                }
            }
            return returnObject;
        } catch (Exception e) {
            e.printStackTrace();
            AIHelpLogger.error("JsonHelper toJavaObject#66", e);
        }
        return null;
    }

    public static <T> List<T> toJavaList(String jsonString, Class<T> clazz) {
        ArrayList<T> javaList = new ArrayList<>();
        if (clazz != null) {
            try {
                JSONArray jsonArray = new JSONArray(jsonString);
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject arrObject = getJsonObject(jsonArray, i);
                    javaList.add(toJavaObject(arrObject.toString(), clazz));
                }
            } catch (Exception e) {
                e.printStackTrace();
                AIHelpLogger.error("JsonHelper toJavaList#82", e);
            }
        }
        return javaList;
    }


    public static JSONObject getJsonObject(JSONArray jsonArray, int index) {
        if (jsonArray == null) return new JSONObject();
        JSONObject jsonObject = jsonArray.optJSONObject(index);
        return jsonObject == null ? new JSONObject() : jsonObject;
    }

    public static JSONObject getJsonObject(JSONObject object, String key) {
        if (object == null) return new JSONObject();
        JSONObject jsonObject = object.optJSONObject(key);
        return jsonObject == null ? new JSONObject() : jsonObject;
    }

    public static JSONArray getJsonArray(JSONObject object, String key) {
        if (object == null) return new JSONArray();
        JSONArray jsonArray = object.optJSONArray(key);
        return jsonArray == null ? new JSONArray() : jsonArray;
    }

    public static String optString(JSONObject object, String key) {
        if (object == null) return "";
        String s = object.optString(key);
        return (TextUtils.isEmpty(s) || s.equals(JSONObject.NULL.toString())) ? "" : s;
    }

    public static JSONArray wrap(Collection<? extends Jsonable> collection) {
        JSONArray jsonArray = new JSONArray();
        if (collection != null) {
            for (Jsonable o : collection) {
                if (o != null) {
                    jsonArray.put(o.toJsonObject());
                }
            }
        }
        return jsonArray;
    }

}
