package net.aihelp.core.mvp;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;

import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.BaseCallback;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.ToastUtil;

import org.json.JSONObject;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;

import okhttp3.Call;

public abstract class AbsPresenter<V extends IView, R extends IRepository> implements IPresenter<V> {

    protected V mView;
    protected R mRepo;
    protected final Context mContext;
    protected SpUtil mSp;

    public AbsPresenter(Context context) {
        mContext = context;
        mRepo = initRepository();
        mSp = SpUtil.getInstance();
        initOtherRepository();
    }

    protected void initOtherRepository() {

    }

    @Override
    public void attachView(V view) {
        this.mView = view;
    }

    @Override
    public void detachView() {
        this.mView = null;
    }

    public boolean isNetworkAvailable() {
        if (mContext == null) return false;
        ConnectivityManager cm = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    protected R initRepository() {
        Type type = getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType) type).getActualTypeArguments();
            Class<R> repoClass = (Class<R>) types[1];
            if (repoClass == IRepository.class) {
                return null;
            }
            try {
                Constructor<R> constructor = repoClass.getDeclaredConstructor(Context.class);
                return constructor.newInstance(mContext);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected <T> void get(String url, JSONObject params, BaseCallback<T> callBack) {
        if (!isNetworkAvailable()) {
            ToastUtil.makeRawToast(mContext, ResResolver.getString("aihelp_network_no_connect"));
            return;
        }
        AIHelpRequest.getInstance().requestGetByAsync(url, params, callBack);
    }

    protected <T> Call post(String url, JSONObject params, BaseCallback<T> callBack) {
        if (!isNetworkAvailable()) {
            ToastUtil.makeRawToast(mContext, ResResolver.getString("aihelp_network_no_connect"));
            return null;
        }
        return AIHelpRequest.getInstance().requestPostByJson(url, params, callBack);
    }

    protected void mqtt(String topicName, JSONObject params) {
        if (!isNetworkAvailable()) {
            ToastUtil.makeRawToast(mContext, ResResolver.getString("aihelp_network_no_connect"));
            return;
        }
        AIHelpMqtt.getInstance().postToServer(topicName, params);
    }

}
