package net.aihelp.config;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.view.LayoutInflater;

import net.aihelp.common.Const;
import net.aihelp.utils.LocaleUtil;
import net.aihelp.utils.TLog;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public class AIHelpContext {

    private Context context;
    private static final Object lock = new Object();
    public static AtomicBoolean successfullyInit = new AtomicBoolean(false);

    private AIHelpContext() {

    }

    @SuppressLint("StaticFieldLeak")
    private static AIHelpContext INSTANCE;

    public static AIHelpContext getInstance() {
        if (INSTANCE == null) {
            synchronized (lock) {
                if (INSTANCE == null) {
                    INSTANCE = new AIHelpContext();
                }
            }
        }
        return INSTANCE;
    }

    public void setContext(Context c) {
        synchronized (lock) {
            context = c;
        }
    }

    public Context getContext() {
        return context;
    }

    public static Context createContextWithLocale(Context context, String language) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            Locale locale = LocaleUtil.getCurrentLocale(language);
            Resources res = context.getResources();
            Configuration config = new Configuration(res.getConfiguration());
            config.setLocale(locale);
            Context newContext = context.createConfigurationContext(config);
            if (newContext != null) {
                return newContext;
            } else {
                config.locale = locale;
                res.updateConfiguration(config, res.getDisplayMetrics());
                return context;
            }
        }
        return context;
    }

    public static Context getLocaleUpdatedContext(Context context, String language) {
        Locale locale = LocaleUtil.getCurrentLocale(language);
        Resources res = context.getResources();
        Configuration config = new Configuration(res.getConfiguration());
        config.locale = locale;
        res.updateConfiguration(config, res.getDisplayMetrics());
        return context;
    }

}
