package net.aihelp.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.BuildConfig;
import net.aihelp.R;
import net.aihelp.config.AIHelpContext;
import net.aihelp.ui.widget.snackbar.Snackbar;

import java.util.WeakHashMap;

import androidx.annotation.RestrictTo;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class ToastUtil {

    private static Toast toast;
    private static Snackbar snackbar;

    @SuppressLint("ShowToast")
    public static void makeText(Context context, String text, boolean isLong) {
        View mView = LayoutInflater.from(context).inflate(R.layout.aihelp_toast_center_view, null);
        TextView textView = mView.findViewById(R.id.aihelp_toast_txt);
        textView.setText(text);

        if (toast != null) {
            textView.setText(text);
        } else {
            toast = Toast.makeText(context, text, isLong ? Toast.LENGTH_LONG : Toast.LENGTH_SHORT);
        }

        toast.setView(mView);
        toast.setGravity(Gravity.CENTER, 0, 0);
        toast.show();
    }

    public static void debugToast(Context context, String text, boolean isLong) {
        if (BuildConfig.DEBUG) {
            makeText(context, text, isLong);
        }
    }

    private static WeakHashMap<View, Snackbar> viewToSnackBarMapping = new WeakHashMap();

    public static void showSnackBar(View view, String message, boolean isLong) {
        if (message != null && message.length() != 0) {
            if (view != null) {
                snackbar = Snackbar.make(view, message, isLong ? Snackbar.LENGTH_LONG : Snackbar.LENGTH_SHORT);
//                View snackBarView = snackbar.getView();
//                snackBarView.setBackgroundColor(Color.parseColor("#F1F1F1"));
//                ((TextView) snackBarView.findViewById(R.id.snackbar_text)).setTextColor(Color.parseColor("#5C7EFF"));
//                snackbar.setActionTextColor(Color.parseColor("#5C7EFF"));
                snackbar.show();

                viewToSnackBarMapping.put(view, snackbar);
            } else {
                makeText(AIHelpContext.getInstance().getContext(), message, false);
            }
        }
    }

    public static void hideSnackBar(View view) {
        if (view != null) {
            Snackbar snackbar = viewToSnackBarMapping.get(view);
            if (snackbar != null && snackbar.isShown()) {
                snackbar.dismiss();
            }
            viewToSnackBarMapping.remove(view);
        }
    }

    public static void showSnackBar(Activity activity, String message, boolean isLong) {
        if (snackbar != null && snackbar.isShown()) return;
        if (message != null && message.length() != 0) {
            Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(android.R.id.content),
                    message, isLong ? Snackbar.LENGTH_LONG : Snackbar.LENGTH_SHORT);
            View snackBarView = snackbar.getView();
            snackBarView.setBackgroundColor(Color.WHITE);
            ((TextView) snackBarView.findViewById(R.id.snackbar_text)).setTextColor(Color.parseColor("#5C7EFF"));
            snackbar.setActionTextColor(Color.parseColor("#5C7EFF"));
            snackbar.show();
        }
    }

    public static void showSnackBar(Activity activity, String message, String action, View.OnClickListener listener) {
        if (message != null && message.length() != 0) {
            snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(android.R.id.content),
                    message, Snackbar.LENGTH_LONG).setAction(action, listener);
            View snackBarView = snackbar.getView();
            snackBarView.setBackgroundColor(Color.parseColor("#EFF1F6"));
            ((TextView) snackBarView.findViewById(net.aihelp.R.id.snackbar_text)).setTextColor(Color.parseColor("#5C7EFF"));
            snackbar.setActionTextColor(Color.parseColor("#5C7EFF"));
            snackbar.show();
        }
    }

    public static void showRawSnackBar(Activity activity, String message, int duration) {
        if (message != null && message.length() != 0) {
            if (activity != null) {
                View contentView = activity.getWindow().getDecorView().findViewById(android.R.id.content);
                Snackbar.make(contentView, message, duration).show();
            } else {
                makeText(AIHelpContext.getInstance().getContext(), message, false);
            }
        }
    }

    public static void showRawSnackBar(Activity activity, String message, String action, int duration, View.OnClickListener listener) {
        if (message != null && message.length() != 0) {
            if (activity != null) {
                Snackbar snackbar = Snackbar.make(activity.getWindow().getDecorView().findViewById(android.R.id.content),
                        message, duration).setAction(action, listener);
                View snackBarText = snackbar.getView().findViewById(R.id.snackbar_text);
                if (snackBarText instanceof TextView) {
                    ((TextView) snackbar.getView().findViewById(net.aihelp.R.id.snackbar_text)).setMaxLines(4);
                }
                View snackBarAction = snackbar.getView().findViewById(R.id.snackbar_action);
                if (snackBarAction instanceof TextView) {
                    ((TextView) snackbar.getView().findViewById(net.aihelp.R.id.snackbar_action)).setTextColor(Color.parseColor("#5C7EFF"));
                }
                snackbar.show();
            } else {
                makeText(AIHelpContext.getInstance().getContext(), message, false);
            }
        }
    }

}
