package net.aihelp.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;

import net.aihelp.R;
import net.aihelp.db.faq.pojo.RealFaq;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;

@RestrictTo(RestrictTo.Scope.LIBRARY)
public class Styles {

    public static int getColorFromAttr(Context context, int attribute) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(new int[]{attribute});
        int color = typedArray.getColor(0, -1);
        typedArray.recycle();
        return color;
    }

    public static int getColor(Context context, int color) {
        return context.getResources().getColor(color);
    }

    public static String getHexColor(Context context, int attribute) {
        return getHexColor(getColor(context, attribute));
    }

    public static String getHexColor(int color) {
        return String.format("#%06X", 16777215 & color);
    }

    public static void setColorFilter(Context context, Drawable drawable, int attr) {
        if (drawable != null) {
            drawable.setColorFilter(getColor(context, attr), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static void setColorFilter(Drawable drawable, int color) {
        if (drawable != null) {
            drawable.setColorFilter(color, PorterDuff.Mode.SRC_ATOP);
        }
    }

    public static float dpToPx(Context context, float dp) {
        if (context == null) return 0f;
        return dp * context.getResources().getDisplayMetrics().density;
    }

    public static void setDrawable(Context context, View view, int drawableId, int color) {
        Drawable drawable = ContextCompat.getDrawable(context, drawableId);
        setColorFilter(context, drawable, color);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }

    }

    public static void setGradientBackground(@NonNull View view, int startColor, int endColor, GradientDrawable.Orientation orientation) {
        int[] colors = new int[]{startColor, endColor};
        GradientDrawable gradientDrawable = new GradientDrawable(orientation, colors);
        ViewCompat.setBackground(view, gradientDrawable);
    }

    public static RealFaq getFAQWithHighlightedSearchTerms(Context context, RealFaq faq, String searchTerms) {
        RealFaq newQuestion = null;
        if (!TextUtils.isEmpty(searchTerms)) {
            String titleText = faq.getFaqTitle();
            String bodyText = faq.getFaqContent();
            String hexColor = getHexColor(getColor(context, R.color.aihelp_color_main));
            String bodyTextCopy;
            String word;

            bodyText = ">" + bodyText + "<";
            titleText = ">" + titleText + "<";
            Pattern pattern = Pattern.compile(">[^<]+<");

            String titleTextCopy = titleText;

            Matcher matcher;
            String content;
            for (matcher = pattern.matcher(titleText); matcher.find(); titleText = titleText.replace(bodyTextCopy, content)) {
                bodyTextCopy = titleTextCopy.substring(matcher.start(), matcher.end());
                content = bodyTextCopy.replaceAll("(?i)(" + searchTerms + ")", "<span style=\"color: " + hexColor + "\">$1</span>");
            }

            bodyTextCopy = bodyText;

            for (matcher = pattern.matcher(bodyText); matcher.find(); bodyText = bodyText.replace(content, word)) {
                content = bodyTextCopy.substring(matcher.start(), matcher.end());
                word = content.replaceAll("(?i)(" + searchTerms + ")", "<span style=\"color: " + hexColor + "\">$1</span>");
            }

            titleText = titleText.substring(1, titleText.length() - 1);
            bodyText = bodyText.substring(1, bodyText.length() - 1);
            newQuestion = new RealFaq(faq.getSecId(), titleText, faq.getFaqMainId(), faq.getFaqDisplayId(), faq.getFaqContentId(), bodyText, faq.isHelpful(), faq.getSearchTerm());
        }

        return newQuestion;
    }

    public static String getNoTemplateFaqContent(String originFaqContent) {
        StringBuilder stringBuilder = new StringBuilder();
        originFaqContent = ">" + originFaqContent + "<";
        Matcher matcher = Pattern.compile(">[^<]+").matcher(originFaqContent);
        while (matcher.find()) {
            String group = matcher.toMatchResult().group().replace(">", "").replace("<", "");
            if (group.trim().contains("body {") || TextUtils.isEmpty(group.trim())) continue;
            stringBuilder.append(group);
        }

        if (TextUtils.isEmpty(stringBuilder.toString())) {
            stringBuilder.append(originFaqContent);
        }
        return stringBuilder.toString();
    }

}

