package net.aihelp.utils;

import android.content.Context;
import android.text.TextUtils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaUtil {

    private static boolean validatePlatformId(String platformId) {
        return !TextUtils.isEmpty(platformId);
    }

    private static boolean validateDomainName(String domainName) {
        if (TextUtils.isEmpty(domainName)) {
            return false;
        } else {
            return Pattern.matches("^.+\\.aihelp.net$", domainName);
        }
    }

    private static boolean validateApiKey(String apiKey) {
        return !TextUtils.isEmpty(apiKey);
    }

    public static void validateInitializeCredentials(Context context, String apiKey, String domainName, String platformId) throws IllegalArgumentException {
        if (context == null) {
            throw new IllegalArgumentException("The application used in the AIHelpSupport.init(context, appKey, domain, appId) is not valid!");
        } else if (!validateApiKey(apiKey)) {
            throw new IllegalArgumentException("The appKey used in the AIHelpSupport.init(context, appKey, domain, appId) is not valid!");
        } else if (!validateDomainName(domainName)) {
            throw new IllegalArgumentException("The domain name used in the AIHelpSupport.init(context, appKey, domain, appId) is not valid!");
        } else if (!validatePlatformId(platformId)) {
            throw new IllegalArgumentException("The appId used in the AIHelpSupport.init(context, appKey, domain, appId) is not valid!");
        }
    }

}
