package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;

import androidx.appcompat.widget.AppCompatTextView;

public class AIHelpTextView extends AppCompatTextView {
    public AIHelpTextView(Context context) {
        super(context);
    }

    public AIHelpTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AIHelpTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override

    protected void onDraw(Canvas canvas) {

        Drawable[] drawables = getCompoundDrawables();

        if (drawables[0] != null) {
            float textWidth = getPaint().measureText(getText().toString());
            int drawablePadding = getCompoundDrawablePadding();
            int drawableWidth = drawables[0].getIntrinsicWidth();
            float bodyWidth = textWidth + drawableWidth + drawablePadding;
            canvas.translate((getWidth() - bodyWidth) / 2, 0);
        }else if (drawables[2] != null) {
            float textWidth = getPaint().measureText(getText().toString());
            int drawablePadding = getCompoundDrawablePadding();
            int drawableWidth = drawables[2].getIntrinsicWidth();
            float bodyWidth = textWidth + drawableWidth + drawablePadding;
            canvas.translate(-(getWidth() - bodyWidth) / 2, 0);
        }

        super.onDraw(canvas);

    }
}
