package net.aihelp.ui.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

import net.aihelp.R;
import net.aihelp.common.IntentValues;
import net.aihelp.ui.helper.SkinHelper;

import androidx.appcompat.widget.AppCompatImageView;

public class AIHelpMsgView extends RelativeLayout {

    private AppCompatImageView ivRight;
    private View unreadDot;

    public AIHelpMsgView(Context context) {
        this(context, null);
    }

    public AIHelpMsgView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AIHelpMsgView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);

        View rootView = View.inflate(context, R.layout.aihelp_layout_msg_view, this);
        ivRight = rootView.findViewById(R.id.aihelp_iv_right);
        unreadDot = rootView.findViewById(R.id.aihelp_v_unread_status);

    }

    protected int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * density + 0.5);
    }

    public void updateImageResource(int supportAction, int resourceId) {
        unreadDot.setVisibility(supportAction == IntentValues.SUPPORT_ACTION_MSG_UNREAD ? VISIBLE : GONE);
        if (supportAction == IntentValues.SUPPORT_ACTION_FAQ) {
            if (TextUtils.isEmpty(SkinHelper.getSkinResource(SkinHelper.SKIN_OPERATION_FAQ))) {
                ivRight.setImageResource(resourceId);
            } else {
                SkinHelper.updateIcon(SkinHelper.SKIN_OPERATION_FAQ, ivRight);
            }
        } else {
            if (TextUtils.isEmpty(SkinHelper.getSkinResource(SkinHelper.SKIN_MSG_NOTIFICATION))) {
                ivRight.setImageResource(resourceId);
            } else {
                SkinHelper.updateIcon(SkinHelper.SKIN_MSG_NOTIFICATION, ivRight);
            }
        }
    }


}
