package net.aihelp.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;

import net.aihelp.R;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.SkinHelper;

import androidx.appcompat.widget.AppCompatButton;
import androidx.core.content.ContextCompat;

public class AIHelpEvaluateFinishButton extends AppCompatButton {

    private Context mContext;
    private int bindRatingBarId;
    private boolean isRtl;

    public AIHelpEvaluateFinishButton(Context context) {
        super(context);
    }

    public AIHelpEvaluateFinishButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.aihelp_evaluate_finish_button);
        bindRatingBarId = typedArray.getResourceId(R.styleable.aihelp_evaluate_finish_button_aihelp_binding_rating_bar, 0);
        typedArray.recycle();

        SkinHelper.updateBackground(SkinHelper.SKIN_RATE_SUBMIT, this);

    }

    public AIHelpEvaluateFinishButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.aihelp_evaluate_finish_button);
        bindRatingBarId = typedArray.getResourceId(R.styleable.aihelp_evaluate_finish_button_aihelp_binding_rating_bar, 0);
        typedArray.recycle();
    }

    @Override
    protected void onDraw(Canvas canvas) {

        Drawable[] drawables = getCompoundDrawables();

        if (drawables[0] != null) {
            isRtl = false;
            float textWidth = getPaint().measureText(getText().toString());
            int drawablePadding = getCompoundDrawablePadding();
            int drawableWidth = drawables[0].getIntrinsicWidth();
            float bodyWidth = textWidth + drawableWidth + drawablePadding;
            canvas.translate((getWidth() - bodyWidth) / 2, 0);
        } else if (drawables[2] != null) {
            isRtl = true;
            float textWidth = getPaint().measureText(getText().toString());
            int drawablePadding = getCompoundDrawablePadding();
            int drawableWidth = drawables[2].getIntrinsicWidth();
            float bodyWidth = textWidth + drawableWidth + drawablePadding;
            canvas.translate(-(getWidth() - bodyWidth) / 2, 0);
        }

        super.onDraw(canvas);
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (bindRatingBarId != 0) {

            ViewGroup viewGroup = (ViewGroup) getParent();
            final AIHelpRatingBar ratingBar = viewGroup.findViewById(bindRatingBarId);

            if (TextUtils.isEmpty(SkinHelper.getSkinResource(SkinHelper.SKIN_RATE_SUBMIT))) {
                bindWithRatingBar(ratingBar);
            }

            final int detailStar = ResponseMqttHelper.getEvaluationEntity().getDetailStar();
            setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mListener != null) {
                        if (ratingBar.getSelectGrade() <= detailStar) {
                            mListener.onNegativeEvaluate(ratingBar.getSelectGrade());
                        } else {
                            mListener.onPositiveEvaluate(ratingBar.getSelectGrade(), ratingBar.isFullStar());
                        }
                    }
                }
            });

        }
    }

    public void bindWithRatingBar(AIHelpRatingBar ratingBar) {
        if (ratingBar != null) {
            ratingBar.setOnStatusChangedListener(new AIHelpRatingBar.OnStatusChangedListener() {
                @Override
                public void onRateStatusChanged(int newRateValue) {
                    if (newRateValue == 5) {
                        invalidateButton(R.drawable.aihelp_bg_finish_button_green, R.drawable.aihelp_svg_ic_check_white);
                    } else {
                        invalidateButton(R.drawable.aihelp_bg_finish_button_white, R.drawable.aihelp_svg_ic_check_green);
                    }
                }
            });
        }
    }

    public void enableButton(boolean enable) {
        if (!isInvalidatedButtonWithSkin(enable)) {
            if (enable) {
                invalidateButton(R.drawable.aihelp_bg_finish_button_white, R.drawable.aihelp_svg_ic_check_green);
            } else {
                invalidateButton(R.drawable.aihelp_bg_finish_button_white, R.drawable.aihelp_svg_ic_check_grey);
            }
        }
        setEnabled(enable);
    }

    private void invalidateButton(int background, int foreground) {
        setBackgroundDrawable(ContextCompat.getDrawable(mContext, background));
        setCompoundDrawablesWithIntrinsicBounds(isRtl ? 0 : foreground, 0, isRtl ? foreground : 0, 0);
    }

    private boolean isInvalidatedButtonWithSkin(boolean enable) {
        setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        if (enable && !TextUtils.isEmpty(SkinHelper.getSkinResource(SkinHelper.SKIN_RATE_SUBMIT))) {
            SkinHelper.updateBackground(SkinHelper.SKIN_RATE_SUBMIT, this);
            return true;
        }
        if (!enable && !TextUtils.isEmpty(SkinHelper.getSkinResource(SkinHelper.SKIN_RATE_SUBMIT_UNABLE))) {
            SkinHelper.updateBackground(SkinHelper.SKIN_RATE_SUBMIT_UNABLE, this);
            return true;
        }
        return false;
    }

    public interface OnEvaluateFinishListener {
        void onNegativeEvaluate(int rate);

        void onPositiveEvaluate(int rate, boolean fullStar);
    }

    private OnEvaluateFinishListener mListener;

    public void setOnEvaluateFinishListener(OnEvaluateFinishListener mListener) {
        this.mListener = mListener;
    }

}
