package net.aihelp.ui.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.ListView;

import net.aihelp.R;
import net.aihelp.ui.webkit.AIHelpWebView;

public class AIHelpBottomSheetWebView extends AIHelpWebView {

    public AIHelpBottomSheetWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @SuppressWarnings("all")
    public void bindToBottomSheet() {
        setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (MotionEvent.ACTION_DOWN == event.getAction()) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                } else if (MotionEvent.ACTION_UP == event.getAction()) {
                    v.getParent().requestDisallowInterceptTouchEvent(false);
                }
                return false;
            }
        });
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int size = (int) ((float) (getResources().getDisplayMetrics().heightPixels * 0.8));
        @SuppressLint("WrongConstant") int newHeightSpec = MeasureSpec.makeMeasureSpec(
                size,
                MeasureSpec.EXACTLY // mode
        );
        super.onMeasure(widthMeasureSpec, newHeightSpec);
    }

}
