package net.aihelp.ui.op;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.ui.loading.helper.VaryViewHelperController;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OperateDataPreparedEvent;
import net.aihelp.data.event.OperatePagerEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.db.op.pojo.OperateSection;
import net.aihelp.ui.adapter.OperateViewPagerAdapter;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.widget.tabs.TabLayout;
import net.aihelp.ui.widget.tabs.TabLayoutMediator;
import net.aihelp.utils.LocalizeHelper;
import net.aihelp.utils.TLog;

import java.util.List;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager2.widget.ViewPager2;

public class OperationFragment extends BaseFragment {

    public static OperationFragment newInstance(Bundle bundle) {
        OperationFragment fraOperate = new OperationFragment();
        fraOperate.setArguments(bundle);
        return fraOperate;
    }

    private OperateViewPagerAdapter mAdapter;

    private boolean isContactUsAlwaysOnline;
    private int mCurrentItem;
    private String elvaTitle = getString(R.string.aihelp_op_cs);

    private View operateView;
    private boolean isNowInOperatePage;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatisticHelper.whenOperationVisible();
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        operateView = inflater.inflate(R.layout.aihelp_fra_operate, null);
        return operateView;
    }

    @Override
    protected int getLoadingTargetViewId() {
        return R.id.aihelp_operate_root;
    }

    @Override
    public void onViewCreated(@NonNull final View view, @Nullable Bundle savedInstanceState) {

        View targetView = view.findViewById(getLoadingTargetViewId());
        if (targetView != null) {
            mVaryViewHelperController = new VaryViewHelperController(targetView);
        }

//        if (!Const.TOGGLE_LOCALIZE_VIA_INIT && !AIHelpDBHelper.getInstance().isOperateStoredSuccessfully()) {
//            if (!EventBus.getDefault().isRegistered(this)) {
//                EventBus.getDefault().register(this);
//            }
//            showLoading();
//            LocalizeHelper.getLocalizeDataFromUrl(LocalizeHelper.FLAG_OP);
//            return;
//        }

        createOperateView(view);
    }

//    @Override
//    public void onEventComing(EventCenter event) {
//        if (event instanceof OperateDataPreparedEvent) {
//            restoreViewState();
//            createOperateView(operateView);
//        }
//    }

    private void createOperateView(@NonNull View view) {
        final TabLayout tabLayout = view.findViewById(R.id.aihelp_tab);
        final ViewPager2 viewPager = view.findViewById(R.id.aihelp_view_pager);
        final List<OperateSection> operateSectionList = AIHelpDBHelper.getInstance().getOperateSectionList();
        tabLayout.setVisibility(operateSectionList.size() == 0 ? View.GONE : View.VISIBLE);

        if (getActivity() == null) {
            TLog.e("OperationFragment getActivity() returns null!");
            return;
        }

        mAdapter = new OperateViewPagerAdapter(getActivity(), getArguments(), operateSectionList);
        viewPager.setAdapter(mAdapter);

        final Bundle bundle = getArguments();
        if (bundle != null) {
            isContactUsAlwaysOnline = getArguments().getBoolean(IntentValues.CONTACT_US_ALWAYS_ONLINE);
            mCurrentItem = getArguments().getInt(IntentValues.OPERATE_SELECT_INDEX);
            elvaTitle = getArguments().getString(IntentValues.OPERATE_SUPPORT_BOT_TITLE, getString(R.string.aihelp_op_cs));
        }

        if (!isNowInOperatePage) {
            isNowInOperatePage = true;
            if (mCurrentItem >= mAdapter.getItemCount() - 1) {
                viewPager.setCurrentItem(mAdapter.getItemCount() - 1, false);
                EventBus.getDefault().post(new OperatePagerEvent(true));
                ResponseMqttHelper.updateElvaSupportActionStatus(isContactUsAlwaysOnline);
            } else {
                viewPager.setCurrentItem(mCurrentItem, false);
            }
        }

        viewPager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback() {

            @Override
            public void onPageSelected(int position) {
                for (int i = 0; i < tabLayout.getTabCount(); i++) {
                    TabLayout.Tab tab = tabLayout.getTabAt(i);
                    if (tab != null) {
                        if (tab.getCustomView() instanceof TextView) {
                            ((TextView) tab.getCustomView()).setTypeface(tab.getPosition() == position ?
                                    Typeface.DEFAULT_BOLD : Typeface.DEFAULT);
                        }
                    }
                }

                if (bundle != null) {
                    EventBus.getDefault().post(new OperatePagerEvent(position == mAdapter.getItemCount() - 1));
                    if (position == mAdapter.getItemCount() - 1) {
                        if (bundle.getBoolean(IntentValues.HUMAN_EMBEDDED_IN_OPERATION)) {
                            EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
                        } else {
                            ResponseMqttHelper.updateElvaSupportActionStatus(isContactUsAlwaysOnline);
                        }
                    } else {
                        EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION, IntentValues.SUPPORT_ACTION_FAQ));
                    }
                }
            }

        });

        TabLayoutMediator mediator = new TabLayoutMediator(tabLayout, viewPager, true, new TabLayoutMediator.TabConfigurationStrategy() {
            @Override
            public void onConfigureTab(@NonNull TabLayout.Tab tab, int position) {

                TextView tabView = new TextView(getContext());

                int[][] states = new int[2][];
                states[0] = new int[]{android.R.attr.state_selected};
                states[1] = new int[]{};

                int[] colors = new int[]{getResources().getColor(R.color.aihelp_color_main), getResources().getColor(R.color.aihelp_color_text_title)};
                ColorStateList colorStateList = new ColorStateList(states, colors);

                String title = position == mAdapter.getItemCount() - 1 ?
                        elvaTitle : operateSectionList.get(position).getSecTitle();
                tabView.setText(title);
                tabView.setTextSize(15);
                tabView.setSingleLine();
                tabView.setEllipsize(TextUtils.TruncateAt.END);
                tabView.setTextColor(colorStateList);
                tabView.setGravity(Gravity.CENTER);
                tab.setCustomView(tabView);

            }
        });
        mediator.attach();
    }

    @Override
    protected void initEventAndData(View contentView) {
    }

    @Override
    protected int getLayout() {
        return 0;
    }

//    @Override
//    public void onDestroy() {
//        super.onDestroy();
//        if (EventBus.getDefault().isRegistered(this)) {
//            EventBus.getDefault().unregister(this);
//        }
//    }
}
