package net.aihelp.ui.op;

import android.os.Bundle;
import android.view.View;

import net.aihelp.R;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.logic.OperatePresenter;
import net.aihelp.db.op.pojo.OperateFaq;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;


public class OperateContentFragment extends BaseFragment<OperatePresenter> {

    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;

    public static OperateContentFragment newInstance(Bundle bundle) {
        OperateContentFragment faqFragment = new OperateContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {
        prepareViews();
        prepareWebView(view);
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
        mPresenter.goFetchOperateContent(extras.getString(IntentValues.FAQ_MAIN_ID));
    }

    private void prepareWebView(View view) {
        mWebView.setWebViewClient(new AIHelpWebViewClient(getContext(), mProgressBar));
        mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, mProgressBar));
    }

    private void prepareViews() {
        mWebView = get(R.id.aihelp_web_view);
        mProgressBar = get(R.id.aihelp_progress_bar);
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_operate_content;
    }

    public void refreshOperateContent(OperateFaq faq) {
        mWebView.loadDataWithBaseURL(null, faq.getFaqContent(), "text/html", "utf-8", null);
        StatisticHelper.whenOperationArticleVisible(faq.getFaqId());
    }

}
