package net.aihelp.ui.helper;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;

import net.aihelp.R;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.db.faq.pojo.RealFaq;
import net.aihelp.db.faq.pojo.Section;
import net.aihelp.ui.cs.ConversationFragment;
import net.aihelp.ui.cs.ElvaBotFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.faq.QuestionContentFragment;
import net.aihelp.ui.faq.QuestionListFragment;
import net.aihelp.ui.faq.SearchFaqFragment;
import net.aihelp.ui.faq.SectionListFragment;
import net.aihelp.ui.faq.SectionRootFragment;
import net.aihelp.ui.faq.IFaqEventListener;
import net.aihelp.ui.op.OperationFragment;
import net.aihelp.ui.op.OperateContentFragment;
import net.aihelp.utils.LocalizeHelper;

import java.util.concurrent.atomic.AtomicBoolean;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;


public class SupportHelper implements IFaqEventListener {

    private final Context context;
    private FragmentManager fragmentManager;
    private final Bundle bundle;
    private AtomicBoolean isSupportStarted = new AtomicBoolean();

    private int supportMode;

    public SupportHelper(Context context, FragmentManager fragmentManager, Bundle bundle) {
        this.context = context;
        this.fragmentManager = fragmentManager;
        this.bundle = bundle;

    }

    public void start() {
        if (!isSupportStarted.get()) {
            supportMode = bundle.getInt(IntentValues.SUPPORT_MODE, 0);
            switch (supportMode) {
                case IntentValues.MODE_ELVA:
                    startElva(bundle, false);
                    break;
                case IntentValues.MODE_CONVERSATION:
                    startConversation(bundle, false);
                    break;
                case IntentValues.MODE_SHOW_SECTION:
                    onIntentToShowSection(bundle);
                    break;
                case IntentValues.MODE_SHOW_SINGLE_FAQ:
                    onIntentToQuestionContent(bundle);
                    break;
                case IntentValues.MODE_OPERATE:
                    onIntentToOperate(bundle);
                    break;
                case IntentValues.MODE_URL:
                    onIntentToFillForm(bundle, false);
                    break;
                default:
                    onIntentToSectionRoot(bundle, false);
                    break;
            }
            isSupportStarted.set(true);
        }
    }

    public void onIntentToSectionRoot(Bundle bundle, boolean isAddToBackStack) {
        SectionRootFragment fraSectionRoot = SectionRootFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = fraSectionRoot.getClass().getName();
        }
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container,
                fraSectionRoot, null, backStackName, false, false);
    }

    private void onIntentToShowSection(Bundle bundle) {
        String sectionId = bundle.getString(IntentValues.SECTION_ID, "");
        if (TextUtils.isEmpty(sectionId)) {
            onIntentToSectionRoot(bundle, false);
            return;
        }
        onIntentToQuestionList(bundle);
    }

    @Override
    public void onIntentToSectionList(Bundle bundle) {
        int mode = bundle.getInt(IntentValues.SUPPORT_MODE, 0);
        SectionListFragment fraSectionList = SectionListFragment.newInstance(bundle);
        FragmentHelper.startFragment(fragmentManager,
                mode == IntentValues.MODE_SHOW_SECTION ? R.id.aihelp_support_fragment_container : R.id.aihelp_faq_section_root,
                fraSectionList, null, null,
                false, false);
    }

    @Override
    public void onIntentToQuestionList(Bundle bundle) {
        String sectionId = bundle.getString(IntentValues.SECTION_ID);
        if (!TextUtils.isEmpty(sectionId)) {
            Section section = AIHelpDBHelper.getInstance().getSection(sectionId);
            if (section == null) {
                section = AIHelpDBHelper.getInstance().getSubSection(sectionId);
            }
            if (section == null) {
                LocalizeHelper.getLocalizeDataFromUrl(LocalizeHelper.FLAG_FAQ);
                if (!API.M_FAQ_URL.contains("//")) {
                    API.M_FAQ_URL = API.REQUEST_SCHEME + API.HOST_URL + API.M_FAQ_URL;
                }
                String url = String.format("%s?uid=%s&type=3&l=%s&appid=%s&sectionid=%s",
                        API.M_FAQ_URL, UserProfile.USER_ID, Const.TARGET_LAN, Const.APP_ID, sectionId);
                bundle.putString(IntentValues.INTENT_URL, url);
                onIntentToFillForm(bundle, supportMode != IntentValues.MODE_SHOW_SECTION);
                return;
            }
        }
        QuestionListFragment fraQuestionList = QuestionListFragment.newInstance(bundle);
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container,
                fraQuestionList, "", getBackStackName(fraQuestionList.getClass().getName()),
                false, false);
    }

    @Override
    public void onIntentToQuestionContent(Bundle bundle) {

        String mainOrDisplayId = bundle.getString(IntentValues.FAQ_MAIN_ID);
        RealFaq faq = AIHelpDBHelper.getInstance().getFaqByMainId(mainOrDisplayId);
        if (faq == null) {
            faq = AIHelpDBHelper.getInstance().getFaqByDisplayId(mainOrDisplayId);
        }

        if (faq == null) {
            LocalizeHelper.getLocalizeDataFromUrl(LocalizeHelper.FLAG_FAQ);
            if (!API.M_FAQ_URL.contains("//")) {
                API.M_FAQ_URL = API.REQUEST_SCHEME + API.HOST_URL + API.M_FAQ_URL;
            }
            String url = String.format("%s?uid=%s&type=3&l=%s&appid=%s&faqid=%s",
                    API.M_FAQ_URL, UserProfile.USER_ID, Const.TARGET_LAN, Const.APP_ID, mainOrDisplayId);
            bundle.putString(IntentValues.INTENT_URL, url);
            onIntentToFillForm(bundle, supportMode != IntentValues.MODE_SHOW_SINGLE_FAQ);
            return;
        }

        if (supportMode == IntentValues.MODE_SHOW_SINGLE_FAQ) {
            bundle.putString(IntentValues.FAQ_MAIN_ID, faq.getFaqMainId());
            bundle.putString(IntentValues.FAQ_CONTENT_ID, faq.getFaqContentId());
        }

        QuestionContentFragment fraQuestionContent = QuestionContentFragment.newInstance(bundle);
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container,
                fraQuestionContent, "", getBackStackName(fraQuestionContent.getClass().getName()),
                true, false);

    }

    @Override
    public void onIntentToSearch(Bundle bundle) {
        SearchFaqFragment fraSearchFaq = SearchFaqFragment.newInstance(bundle);
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_faq_section_root,
                fraSearchFaq, "tag_faq_search", fraSearchFaq.getClass().getName(),
                false, false);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void afterTextChanged(Editable s) {

    }

    @Override
    public void onTextChanged(final CharSequence s, int start, int before, int count) {
        SearchFaqFragment searchFragment = (SearchFaqFragment) this.fragmentManager.findFragmentByTag("tag_faq_search");
        if (searchFragment != null) {
            searchFragment.onQuery(String.valueOf(s).trim());
        }
    }

    private Fragment getTopMostFaqFragment() {
        return FragmentHelper.getTopMostFragment(this.fragmentManager);
    }

    private String getBackStackName(String backStackName) {

        if (supportMode == IntentValues.MODE_SHOW_SECTION) {
            if (backStackName.equals(QuestionContentFragment.class.getName())) {
                return backStackName;
            }
            return "";
        }

        if (supportMode == IntentValues.MODE_SHOW_SINGLE_FAQ) {
            return "";
        }

        // 默认情况下，加入回退栈
        return backStackName;
    }

    public void startElva(Bundle bundle, boolean isAddToBackStack) {
        if(MqttConfig.getInstance().isConnected()) return;
        Fragment elvaBot = ElvaBotFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = elvaBot.getClass().getName();
        }
        FragmentHelper.startFragment(fragmentManager,
                R.id.aihelp_support_fragment_container, elvaBot,
                backStackName, backStackName, false, false);
    }

    public void startConversation(Bundle bundle, boolean isAddToBackStack) {
        Fragment conversationFragment = ConversationFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = conversationFragment.getClass().getName();
        }
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container, conversationFragment,
                backStackName, backStackName, false, false);
    }

    @Override
    public void onIntentToFillForm(Bundle bundle, boolean isAddToBackStack) {
        IntentUrlFragment formFragment = IntentUrlFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = formFragment.getClass().getName();
        }
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container, formFragment,
                backStackName, backStackName, false, false);
    }

    private void onIntentToOperate(Bundle bundle) {
        OperationFragment operateFragment = OperationFragment.newInstance(bundle);
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container,
                operateFragment, null, null,
                false, false);
    }

    @Override
    public void onIntentToOperateContent(Bundle bundle) {
        OperateContentFragment fraOperateContent = OperateContentFragment.newInstance(bundle);
        FragmentHelper.startFragment(fragmentManager, R.id.aihelp_support_fragment_container,
                fraOperateContent, "fraOperateContent", fraOperateContent.getClass().getName(),
                true, false);
    }

}
