package net.aihelp.ui.helper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import net.aihelp.R;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.ui.image.RequestCreator;
import net.aihelp.core.ui.image.Target;
import net.aihelp.core.ui.image.TargetAdapter;
import net.aihelp.data.model.SDKConfigEntity;
import net.aihelp.ui.chunk.NinePatchChunk;
import net.aihelp.ui.widget.AIHelpLoadingImageView;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class SkinHelper {

    private static final LinkedHashMap<Integer, String> sortedSkinUrls = new LinkedHashMap<>();

    public static final int SKIN_PORTRAIT_BOT = -1;
    public static final int SKIN_PORTRAIT_ADMIN = -2;
    public static final int SKIN_PORTRAIT_USER = -3;

    public static final int SKIN_HOME_DOCK = 1;
    public static final int SKIN_STATUS_BAR = 2;
    public static final int SKIN_NAVIGATION_BAR = 3;
    public static final int SKIN_GO_BACK = 4;
    public static final int SKIN_CHAT_BOTTOM_AREA = 5;
    public static final int SKIN_INPUT_AREA = 6;
    public static final int SKIN_ADMIN_MSG = 7;
    public static final int SKIN_USER_MSG = 8;
    public static final int SKIN_MSG_NOTIFICATION = 9;
    public static final int SKIN_OPERATION_FAQ = 10;
    public static final int SKIN_RATE_UNCHECKED = 11;
    public static final int SKIN_RATE_CHECKED = 12;
    public static final int SKIN_RATE_SUBMIT_UNABLE = 13;
    public static final int SKIN_RATE_SUBMIT = 14;
    public static final int SKIN_FAQ_UNHELPFUL = 15;
    public static final int SKIN_FAQ_HELPFUL = 16;
    public static final int SKIN_SEND_MSG = 17;
    public static final int SKIN_UPLOAD_MEDIA = 18;
    public static final int SKIN_ERROR_PIC = 19;
    public static final int SKIN_CHAT_BACKGROUND_PORTRAIT = 20;
    public static final int SKIN_CHAT_BACKGROUND_LANDSCAPE = 21;

    public static void addSkinResource(int type, String url) {
        sortedSkinUrls.put(type, url);
    }

    public static String getSkinResource(int skinType) {
        if (sortedSkinUrls.size() == 0) return "";
        return sortedSkinUrls.get(skinType);
    }

    public static void updateBackground(final int skinType, final View targetView) {
        if (targetView != null && AIHelpContext.getInstance().getContext() != null) {

            final String skinResource = getSkinResource(skinType);
            if (TextUtils.isEmpty(skinResource)) return;
            final Drawable originBackground = targetView.getBackground();
            Picasso.get().load(skinResource).into(new Target() {
                @Override
                public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                    if (skinResource.endsWith(".9.png")) {
                        NinePatchDrawable patchDrawable = NinePatchChunk.create9PatchDrawable(targetView.getContext(), bitmap, "");
                        targetView.setBackgroundDrawable(patchDrawable);
                        return;
                    }
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
                        targetView.setBackground(new BitmapDrawable(targetView.getResources(), bitmap));
                    }
                }

                @Override
                public void onBitmapFailed(Exception e, Drawable errorDrawable) {
                    targetView.setBackground(originBackground);
                }

                @Override
                public void onPrepareLoad(Drawable placeHolderDrawable) {

                }
            });
        }

    }

    public static void updateIcon(int skinType, View view) {
        if (view instanceof ImageView && AIHelpContext.getInstance().getContext() != null) {
            String skinResource = getSkinResource(skinType);
            if (TextUtils.isEmpty(skinResource)) return;
            ImageView imageView = (ImageView) view;
            Picasso.get().load(skinResource).placeholder(imageView.getDrawable()).into(imageView);
        }
    }

    public static void prepareSkinResources(Context context, SDKConfigEntity.SdkConfigImgBean
            sdkConfigImg, List<SDKConfigEntity.SdkConfigTopicBean> skinUrls) {

        if (skinUrls == null) {
            skinUrls = new ArrayList<>();
        }

        if (sdkConfigImg != null) {
            if (!TextUtils.isEmpty(sdkConfigImg.getRobot_Avatar())) {
                skinUrls.add(new SDKConfigEntity.SdkConfigTopicBean(SkinHelper.SKIN_PORTRAIT_BOT, sdkConfigImg.getRobot_Avatar()));
            }
            if (!TextUtils.isEmpty(sdkConfigImg.getCustomer_Avatar())) {
                skinUrls.add(new SDKConfigEntity.SdkConfigTopicBean(SkinHelper.SKIN_PORTRAIT_ADMIN, sdkConfigImg.getCustomer_Avatar()));
            }
            if (!TextUtils.isEmpty(sdkConfigImg.getPlayer_Avatar())) {
                skinUrls.add(new SDKConfigEntity.SdkConfigTopicBean(SkinHelper.SKIN_PORTRAIT_USER, sdkConfigImg.getPlayer_Avatar()));
            }
        }

        if (!skinUrls.isEmpty()) {
            for (final SDKConfigEntity.SdkConfigTopicBean bean : skinUrls) {
                final String skinUrl = bean.getTopic_Content();
                final String targetPath = getTargetPath(context, skinUrl);

                if (new File(targetPath).exists()) {
                    SkinHelper.addSkinResource(bean.getTopic_Type(), targetPath);
                    continue;
                }

                AIHelpRequest.getInstance().requestDownloadFile(skinUrl, targetPath, new ReqCallback<String>() {
                    @Override
                    public void onReqSuccess(String result) {
                        SkinHelper.addSkinResource(bean.getTopic_Type(), targetPath);
                    }
                });
            }
        }
    }

    private static String getTargetPath(Context context, String url) {
        String[] splitArr = url.split("/");
        String fileName = splitArr[splitArr.length - 1];

        String dirPath = "";
        File filesDir = context.getFilesDir();
        if (filesDir != null) {
            dirPath = filesDir.getAbsolutePath() + "/skin";
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                if (dirFile.mkdirs()) {
                    return dirFile.getAbsolutePath() + File.separator + fileName;
                }
            }
        }
        return dirPath + File.separator + fileName;
    }

}