package net.aihelp.ui.helper;

import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.model.EvaluationEntity;
import net.aihelp.utils.TLog;

import java.io.File;


public class ResponseMqttHelper {

    private static EvaluationEntity evaluationEntity;
    private static boolean isTicketUnFinish;
    private static boolean isTicketUnRated;
    private static boolean isFormSubmitted;
    private static boolean hasUnreadMsg;

    public static boolean isHasUnreadMsg() {
        return hasUnreadMsg;
    }

    public static void setHasUnreadMsg(boolean hasUnreadMsg) {
        ResponseMqttHelper.hasUnreadMsg = hasUnreadMsg;
    }

    public static boolean isFormSubmitted() {
        return isFormSubmitted;
    }

    public static void setFormSubmitStatus(boolean formSubmitStatus) {
        ResponseMqttHelper.isFormSubmitted = formSubmitStatus;
    }

    public static void resetFlagsAfterMsgViewed() {
        setFormSubmitStatus(false);
        setHasUnreadMsg(false);
    }

    public static void resetFlagsWhenUserInfoUpdated() {
        resetFlagsAfterMsgViewed();
    }

    public static boolean isTicketUnFinish() {
        return isTicketUnFinish;
    }

    public static boolean isTicketUnRated() {
        return isTicketUnRated;
    }

    public static void setTicketUnFinish(boolean isTicketOpening) {
        ResponseMqttHelper.isTicketUnFinish = isTicketOpening;
    }

    static void setEvaluationEntity(EvaluationEntity evaluationEntity) {
        ResponseMqttHelper.evaluationEntity = evaluationEntity;
    }

    static void setTicketUnRated(boolean isTicketUnRated) {
        ResponseMqttHelper.isTicketUnRated = isTicketUnRated;
    }

    public static EvaluationEntity getEvaluationEntity() {
        if (evaluationEntity == null) {
            evaluationEntity = new EvaluationEntity();
        }
        return evaluationEntity;
    }

    public static void updateElvaSupportActionStatus(boolean isContactUsAlwaysOnline) {
        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
        if (!MqttConfig.getInstance().isConnected()) return;

        if (ResponseMqttHelper.isHasUnreadMsg() || ResponseMqttHelper.isFormSubmitted()) {
            EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION,
                    IntentValues.SUPPORT_ACTION_MSG_UNREAD));
        } else if (isContactUsAlwaysOnline || ResponseMqttHelper.isTicketUnFinish()) {
            EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION,
                    IntentValues.SUPPORT_ACTION_MSG));
        }
    }

    public static void tryUploadLog(boolean isUploadLog) {
        // Enable the fetch-message request after user submitted a ticket
        Const.TOGGLE_FETCH_MESSAGE = true;
        if (isUploadLog && Const.TOGGLE_UPLOAD_LOG && !TextUtils.isEmpty(Const.LOG_UPLOAD_PATH)) {
            File file = new File(Const.LOG_UPLOAD_PATH);
            if (file.exists() && !file.isDirectory()) {
                String fileName = file.getName();
                if (!TextUtils.isEmpty(fileName)) {
                    int index = fileName.lastIndexOf(".");
                    if (index > 0 && index < fileName.length()) {
                        String ext = fileName.substring(index).toLowerCase();
                        if (".txt".equals(ext) || ".log".equals(ext) || ".bytes".equals(ext)) {
                            AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_FILE_URL, file, new UploadCallback<String>() {
                                @Override
                                public void onReqSuccess(String result) {
                                    TLog.e("upload log success");
                                }
                            });
                        }
                    }
                }
            }
        }
    }

}
