package net.aihelp.ui.helper;

import net.aihelp.data.model.cs.BotTag;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.core.net.json.JsonHelper;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 优先级逻辑顺序:  1.有机器人不知道    返回3
 * 2.有faq 点踩       返回2
 * 3.有表单提交        返回8
 * 4.有表单点击        返回7
 * 5.有faq 有赞       返回1
 * 6.有faq 无评价     返回5
 * 7.无faq 有表单      返回4
 * 8.action 有action  返回6
 * 9.无操作            返回0(默认无操作)
 * 注:1,4,6(赞) 2,3(踩) 其他无图标
 * <p>
 * 1、使用链表对优先级进行倒序插入（规避 indexOf 方法返回 -1 的可能），同时在业务逻辑中进行实时数据更新
 * 2、如果新传入的操作在链表中的角标更大，则说明优先级更高，对数据值进行更新
 * 3、logoutType 是全局静态属性，需要在登出 mqtt 后进行重置
 */
public class LogoutMqttHelper {

    private static final LinkedList<String> sortedTypes = new LinkedList<>();

    private static final String LOGOUT_TYPE_DEFAULT = "0";
    public static final String LOGOUT_TYPE_ACTION_DISPLAY = "6";
    public static final String LOGOUT_TYPE_BOT_STUPID = "3";

    public static final String LOGOUT_TYPE_FAQ_DISPLAY = "5";
    public static final String LOGOUT_TYPE_FAQ_HELPFUL = "1";
    public static final String LOGOUT_TYPE_FAQ_UNHELPFUL = "2";

    public static final String LOGOUT_TYPE_FORM_DISPLAY = "4";
    public static final String LOGOUT_TYPE_FORM_GOTO_PAGE = "7";
    public static final String LOGOUT_TYPE_FORM_SUBMIT = "8";

    private static String logoutType = LOGOUT_TYPE_DEFAULT;

    private static LinkedList<String> getPriorityTypes() {
        if (sortedTypes.size() == 0) {
            sortedTypes.add(LOGOUT_TYPE_DEFAULT);
            sortedTypes.add(LOGOUT_TYPE_ACTION_DISPLAY);
            sortedTypes.add(LOGOUT_TYPE_FORM_DISPLAY);
            sortedTypes.add(LOGOUT_TYPE_FAQ_DISPLAY);
            sortedTypes.add(LOGOUT_TYPE_FAQ_HELPFUL);
            sortedTypes.add(LOGOUT_TYPE_FORM_GOTO_PAGE);
            sortedTypes.add(LOGOUT_TYPE_FORM_SUBMIT);
            sortedTypes.add(LOGOUT_TYPE_FAQ_UNHELPFUL);
            sortedTypes.add(LOGOUT_TYPE_BOT_STUPID);
        }
        return sortedTypes;
    }

    public static void updateType(String type) {
        LinkedList<String> priorityTypes = getPriorityTypes();
        int baseType = priorityTypes.indexOf(logoutType);
        if (priorityTypes.indexOf(type) > baseType) {
            logoutType = type;
        }
    }

    public static String getLogoutType() {
        return logoutType;
    }

    public static void resetTypeWhenLogout() {
        logoutType = LOGOUT_TYPE_DEFAULT;
    }

    public static JSONArray getTagsFromMessageList(JSONArray msgArray) {
        JSONArray tagArray = new JSONArray();
        for (int i = 0; i < msgArray.length(); i++) {
            JSONObject jsonObject = JsonHelper.getJsonObject(msgArray, i);
            if (jsonObject.has("tags")) {
                JSONArray tags = JsonHelper.getJsonArray(jsonObject, "tags");
                for (int j = 0; j < tags.length(); j++) {
                    tagArray.put(tags.optJSONObject(j));
                }
            }
        }
        return tagArray;
    }

}
