package net.aihelp.ui.helper;

import android.text.TextUtils;
import android.widget.Toast;

import net.aihelp.BuildConfig;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.data.model.EvaluationEntity;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;


public class LoginMqttHelper {

    public static List<ConversationMsg> getLoginResponse(String response) {

        final ArrayList<ConversationMsg> list = new ArrayList<>();
        try {
            JSONObject loginObj = new JSONObject(response);
            if (loginObj.has("errorCode")) {
                TLog.e("mqtt login failed, " + response);
                if (BuildConfig.DEBUG) {
                    Toast.makeText(AIHelpContext.getInstance().getContext(),
                            "MQTT Login failed, errorCode " + loginObj.optString("errorCode"), Toast.LENGTH_SHORT).show();
                }
                return list;
            }

            String msgJson = TextUtils.isEmpty(loginObj.optString("chat_private")) ? "{}" : loginObj.optString("chat_private");
            JSONObject chatHistory = new JSONObject(msgJson);
            ResponseMqttHelper.setTicketUnFinish(chatHistory.length() > 0);
            ResponseMqttHelper.setTicketUnRated(chatHistory.has("flag"));

            if (!TextUtils.isEmpty(Const.CUSTOM_STORY_NODE) || !Const.isLocalWelcomeAvailable) {
                if (String.valueOf(MqttConfig.TYPE_ELVA_BOT).equals(loginObj.optString("re_type"))) {
                    final JSONArray msgs = JsonHelper.getJsonArray(loginObj, "msgs");
                    switch (loginObj.optInt("contextType")) {
                        case 0: // 有机器人历史客诉
                        case 2: // 默认欢迎语
                            if (msgs.length() > 0) {
                                list.add(ElvaBotHelper.getMqttReply(JsonHelper.getJsonObject(msgs, 0).toString(), true));
                            }
                            // clear all elva message histories to avoid sending old messages to server
                            AIHelpDBHelper.getInstance().clearElvaMsg();
                            break;
                    }
                }
            }

            if (String.valueOf(MqttConfig.TYPE_CONVERSATION).equals(loginObj.optString("re_type"))) {
                // fill in welcome msg
                ConversationMsg defaultWelcomeMsg = new ConversationMsg(ConversationMsg.TYPE_ADMIN_TEXT, ConversationMsg.STATUS_SUCCESS);
                defaultWelcomeMsg.setTimeStamp(100);
                defaultWelcomeMsg.setMsgContent(getWelcomeMessage(loginObj.optString("vip_wlcm_msg")));
                list.add(defaultWelcomeMsg);

                // ticket history
                list.addAll(ConversationHelper.getRetrievedMsgList(chatHistory));
            }

            if (loginObj.has("evaluation")) {
                ResponseMqttHelper.setEvaluationEntity(JsonHelper.toJavaObject(loginObj.optString("evaluation"), EvaluationEntity.class));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return list;
    }

    private static String getWelcomeMessage(String mqttWelcome) {
        if (!TextUtils.isEmpty(Const.CUSTOM_WELCOME_MSG)) {
            return Const.CUSTOM_WELCOME_MSG;
        } else if (!TextUtils.isEmpty(Const.DASHBOARD_WELCOME_MSG)) {
            return Const.DASHBOARD_WELCOME_MSG;
        } else if (!TextUtils.isEmpty(mqttWelcome)) {
            return mqttWelcome;
        } else {
            return "How can we help you?";
        }
    }

    public static JSONObject getLoginParams() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("appId", Const.APP_ID);
            obj.put("gameId", Const.APP_ID);
            obj.put("gameUid", UserProfile.USER_ID);
            if (Const.PRIVACY_POLICY_ACCEPTED) { // toggle for certain user
                obj.put("userPlayerName", UserProfile.USER_NAME);
                obj.put("userDisplayName", UserProfile.USER_NAME);
                obj.put("cmdBaseTime", Long.toString(System.currentTimeMillis()));
                obj.put("type", MqttConfig.getInstance().getLoginType());
                obj.put("gameInfo", DeviceInfoUtil.getInstance().getGameInfo());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

}
