package net.aihelp.ui.helper;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.R;
import net.aihelp.common.API;
import net.aihelp.common.ConfigValues;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.ui.adapter.TextWatcherAdapter;

import org.json.JSONObject;

import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;


public class FaqEvaluateHelper {

    private Bundle faqDetailBundle;
    private LinearLayout mQuestionFooter;
    private ViewGroup mEvaluateFaqLayout;
    private ViewGroup mAfterEvaluateLayout;
    private AppCompatTextView mTvAdvice;

    public void getViewsPrepared(LinearLayout questionFooter, ViewGroup evaluateFaqLayout, ViewGroup
            afterEvaluateLayout, AppCompatTextView tvAdvice) {
        mQuestionFooter = questionFooter;
        mEvaluateFaqLayout = evaluateFaqLayout;
        mAfterEvaluateLayout = afterEvaluateLayout;
        mTvAdvice = tvAdvice;
        mQuestionFooter.setVisibility(Const.TOGGLE_EVALUATE_DETAIL_FAQ ? View.VISIBLE : View.GONE);
    }

    public void setFaqDetailBundle(Bundle faqDetailBundle) {
        this.faqDetailBundle = faqDetailBundle;
    }

    public void updateEvaluateFaq(boolean isHelpful, String faqMainId, String faqContentId) {
        if (isHelpful) {
            mEvaluateFaqLayout.setVisibility(View.GONE);
            mAfterEvaluateLayout.setVisibility(View.VISIBLE);
            mTvAdvice.setVisibility(View.GONE);
        } else {
            mEvaluateFaqLayout.setVisibility(View.GONE);
            mAfterEvaluateLayout.setVisibility(View.VISIBLE);
            mTvAdvice.setVisibility(View.VISIBLE);

            if (faqDetailBundle != null) {
                int supportMoment = faqDetailBundle.getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);
                if (supportMoment == ConfigValues.MOMENT_AFTER_MARKING_UNHELPFUL) {
                    EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION, IntentValues.SUPPORT_ACTION_MSG));
                }
            }

        }
        AIHelpDBHelper.getInstance().afterFaqEvaluated(faqMainId, isHelpful);
        StatisticHelper.postHelpfulStatus(faqContentId, isHelpful);
    }

    public void showAdviceAlert(final Context context, final String faqMainId, final boolean isBot) {
        final AlertDialog feedbackDialog = new AlertDialog.Builder(context)
                .setContentView(R.layout.aihelp_dia_advice)
                .setWidthByDevice()
                .create();

        final EditText etFeedback = feedbackDialog.getView(R.id.aihelp_et_feedback);
        final TextView tvConfirm = feedbackDialog.getView(R.id.aihelp_tv_confirm);

        feedbackDialog.setOnClickListener(R.id.aihelp_tv_cancel, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                feedbackDialog.dismiss();
            }
        });
        etFeedback.addTextChangedListener(new TextWatcherAdapter() {
            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                tvConfirm.setEnabled(!TextUtils.isEmpty(s.toString().trim()));
                tvConfirm.setAlpha(TextUtils.isEmpty(s) ? 0.5f : 1);
            }
        });

        tvConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (TextUtils.isEmpty(etFeedback.getText().toString().trim())) {
                    Toast.makeText(context, context.getString(R.string.aihelp_faq_feedback), Toast.LENGTH_SHORT).show();
                    return;
                }
                feedbackDialog.dismiss();
                postFeedbackOnFaq(faqMainId, etFeedback.getText().toString().trim(), String.valueOf(System.currentTimeMillis()), isBot);
                mQuestionFooter.setVisibility(View.GONE);
            }
        });
        feedbackDialog.show();
    }

    private static void postFeedbackOnFaq(String faqPublishId, String feedbackMsg, String createTime, boolean isBot) {
        JSONObject params = new JSONObject();
        try {
            params.put("Language", Const.TARGET_LAN);
            params.put("PlayerId", String.format("%s|%s", Const.APP_ID, UserProfile.USER_ID));
            params.put("PlayerName", UserProfile.USER_NAME);
            params.put("FaqId", faqPublishId);
            params.put("Message", feedbackMsg);
            params.put("Type", isBot ? 1: 2);
            params.put("CreateTime", createTime);
        } catch (Exception e) {
            e.printStackTrace();
        }
        AIHelpRequest.getInstance().requestPostByJson(API.FAQ_FEEDBACK_URL, params, null);
    }

    private FaqEvaluateHelper() {

    }

    public static FaqEvaluateHelper getInstance() {
        return FaqEvaluateHelper.Holder.INSTANCE;
    }

    private static class Holder {
        private static final FaqEvaluateHelper INSTANCE = new FaqEvaluateHelper();
    }


}
