package net.aihelp.ui.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;

import net.aihelp.R;
import net.aihelp.ui.adapter.TextWatcherAdapter;
import net.aihelp.ui.adapter.EvaluateSuggestAdapter;
import net.aihelp.ui.widget.AIHelpBottomSheetDialog;
import net.aihelp.ui.widget.AIHelpBottomSheetListView;
import net.aihelp.ui.widget.AIHelpEvaluateFinishButton;
import net.aihelp.utils.AppInfoUtil;

import org.json.JSONArray;


public class EvaluateHelper {

    private EvaluateHelper() {
    }

    public static EvaluateHelper getInstance() {
        return EvaluateHelper.Holder.INSTANCE;
    }

    private static class Holder {
        private static final EvaluateHelper INSTANCE = new EvaluateHelper();
    }

    private boolean isShowing;
    private AIHelpBottomSheetDialog rateSupportDialog;
    private AIHelpBottomSheetDialog suggestDialog;

    public boolean isShowing() {
        return isShowing;
    }

    public void setShowing(boolean showing) {
        isShowing = showing;
    }

    public void showRateSupport(final Context context, final boolean isRateApp, final OnConfirmEvaluateListener listener) {
        rateSupportDialog = new AIHelpBottomSheetDialog(context);
        rateSupportDialog.setContentView(R.layout.aihelp_dia_rate_support);
        rateSupportDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                setShowing(false);
            }
        });

        AIHelpEvaluateFinishButton button = rateSupportDialog.getContentView().findViewById(R.id.aihelp_btn_confirm);
        button.setOnEvaluateFinishListener(new AIHelpEvaluateFinishButton.OnEvaluateFinishListener() {
            @Override
            public void onNegativeEvaluate(int rate) {
                showEvaluateSuggestion(context, rate, listener);
            }

            @Override
            public void onPositiveEvaluate(int rate, boolean fullStar) {
                if (listener != null) {
                    if (listener.onConfirmEvaluate(rate, null, null)) {
                        rateSupportDialog.dismiss();
                        showThanksAfterEvaluate(context, fullStar, isRateApp);
                        setShowing(false);
                    }
                }
            }
        });

        rateSupportDialog.show();
        setShowing(true);

    }

    private void showThanksAfterEvaluate(final Context context, boolean isFiveStar, boolean isRateApp) {
        final AIHelpBottomSheetDialog showThanksDialog = new AIHelpBottomSheetDialog(context, R.layout.aihelp_dia_show_thanks);
        View goRateLayout = showThanksDialog.getContentView().findViewById(R.id.aihelp_ll_go_rate);
        goRateLayout.setVisibility(isRateApp && isFiveStar ? View.VISIBLE : View.GONE);
        showThanksDialog.getContentView().findViewById(R.id.aihelp_btn_go_rate).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AppInfoUtil.goRateApp(context);
                showThanksDialog.dismiss();
            }
        });
        showThanksDialog.show();
        showThanksDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                setShowing(false);
            }
        });
    }

    @SuppressLint("ClickableViewAccessibility")
    private void showEvaluateSuggestion(final Context context, final int rate, final OnConfirmEvaluateListener listener) {
        suggestDialog = new AIHelpBottomSheetDialog(context);
        suggestDialog.setContentView(R.layout.aihelp_dia_evaluate_suggestion);

        AIHelpBottomSheetListView lvSuggest = suggestDialog.getContentView().findViewById(R.id.aihelp_lv_suggest);
        final EditText etSuggest = suggestDialog.getContentView().findViewById(R.id.aihelp_et_suggest);
        AIHelpEvaluateFinishButton button = suggestDialog.getContentView().findViewById(R.id.aihelp_btn_confirm);

        etSuggest.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (MotionEvent.ACTION_DOWN == event.getAction()) {
                    v.getParent().requestDisallowInterceptTouchEvent(true);
                } else if (MotionEvent.ACTION_UP == event.getAction()) {
                    v.getParent().requestDisallowInterceptTouchEvent(false);
                }
                return false;
            }
        });

        suggestDialog.getContentView().findViewById(R.id.aihelp_iv_close).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                suggestDialog.dismiss();
            }
        });

        final EvaluateSuggestAdapter suggestAdapter = new EvaluateSuggestAdapter(context, lvSuggest,
                ResponseMqttHelper.getEvaluationEntity().getDetail());
        lvSuggest.setAdapter(suggestAdapter);
        lvSuggest.bindBottomSheetDialog(suggestDialog.getContentView());

        updateButtonEnableStatus(button, etSuggest, suggestAdapter);
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                if (listener != null) {
                    if (listener.onConfirmEvaluate(rate, etSuggest.getText().toString().trim(),
                            suggestAdapter.getSelectedItems())) {
                        if (suggestDialog != null) suggestDialog.dismiss();
                        if (rateSupportDialog != null) rateSupportDialog.dismiss();
                        showThanksAfterEvaluate(context, false, false);
                        setShowing(false);
                    }
                }
            }
        });
        suggestDialog.show();
    }

    private void updateButtonEnableStatus(final AIHelpEvaluateFinishButton button, final EditText etSuggest, final EvaluateSuggestAdapter suggestAdapter) {

        button.enableButton(false);

        etSuggest.addTextChangedListener(new TextWatcherAdapter() {
            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                button.enableButton(suggestAdapter.isHasSelectedItem() || !TextUtils.isEmpty(s.toString().trim()));
            }
        });

        suggestAdapter.setOnSelectChangedListener(new EvaluateSuggestAdapter.OnSelectChangedListener() {
            @Override
            public void onSelectChanged() {
                button.enableButton(suggestAdapter.isHasSelectedItem() || !TextUtils.isEmpty(etSuggest.getText().toString().trim()));
            }
        });

    }

    public interface OnConfirmEvaluateListener {
        boolean onConfirmEvaluate(int rate, String input, JSONArray selected);
    }

}
