package net.aihelp.ui.helper;

import android.content.Context;
import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.Const;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.util.elva.parser.ElvaBotParser;
import net.aihelp.core.util.elva.util.Searcher;
import net.aihelp.core.util.logger.AIHelpLogger;
import net.aihelp.data.model.cs.BotFormUrl;
import net.aihelp.data.model.cs.BotUrl;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.data.model.cs.ElvaBotMsg;
import net.aihelp.data.model.cs.BotTag;
import net.aihelp.init.ConfigUtil;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.ArrayList;

import net.aihelp.core.util.elva.ElvaBot;
import net.aihelp.core.util.elva.xml.XML;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


public class ElvaBotHelper {

    private static ElvaBot sBotInstance;

    private ElvaBotHelper() {
    }

    public static void initBot(Context context) {
        ConfigUtil.prepareElvaBotConfigs(context);
        try {
            String rootPath = context.getFilesDir().getAbsolutePath();
            Searcher searcher = new Searcher();
            ElvaBotParser parser = new ElvaBotParser(Const.APP_ID, Const.TARGET_LAN);
            sBotInstance = parser.parse(new FileInputStream(rootPath + "/bot/context.xml"),
                    new FileInputStream(rootPath + "/bot/splitters.xml"),
                    new FileInputStream(rootPath + "/bot/substitutions.xml"),
                    searcher.search(rootPath + "/AIML/" + Const.TARGET_LAN, ".*\\.aiml"));
            if (sBotInstance != null)
                sBotInstance.getContext().outputStream(new ByteArrayOutputStream());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ElvaBotMsg getDefaultReply() {
        return getLocalReply("DEFAULTWELCOMETEXT");
    }

    public static ElvaBotMsg getLocalReply(String userInput) {

        ElvaBotMsg botMsg = new ElvaBotMsg();
        botMsg.setUserInput(userInput);

        if (isElvaPrepared()) {
            try {
                // 解析用户输入后得到的 json 数据

                JSONObject jsonObj = new JSONObject(XML.toJSONObject(sBotInstance.respondXml(userInput)).optString("msgs"));

                // mark bot stupid when there is nothing matched
                if (jsonObj.length() == 0) {
                    botMsg.setBotStupid(true);
                }

                // 解析 msg
                if (jsonObj.has("msg")) {
                    String msg = jsonObj.optString("msg");
                    if (TextUtils.isEmpty(msg) || "null".equals(msg)) {
                        botMsg.setBotStupid(true);
                    } else {
                        botMsg.setBotMsg(msg);
                    }
                }

                // 解析 action 信息
                if (jsonObj.has("actions")) {
                    ArrayList<String> actions = new ArrayList<>();
                    JSONArray actionArray = JsonHelper.getJsonArray(JsonHelper.getJsonObject(jsonObj, "actions"), "action");
                    for (int i = 0; i < actionArray.length(); i++) {
                        JSONObject jsonObject = JsonHelper.getJsonObject(actionArray.getJSONObject(i), "action");
                        actions.add(jsonObject.optString("reply"));
                    }
                    botMsg.setActions(actions);
                }

                // 解析外链
                if (jsonObj.has("url")) {
                    JSONObject urlObj = JsonHelper.getJsonObject(jsonObj, "url");
                    String urlTitle = urlObj.optString("title");
                    String urlAddress = urlObj.optString("content");
                    botMsg.setBotUrl(new BotUrl(urlTitle, urlAddress));
                }

                // 解析表单链接
                if (jsonObj.has("url2")) {
                    JSONObject formUrlObj = JsonHelper.getJsonObject(jsonObj, "url2");
                    String formTitle = formUrlObj.optString("title");
                    String formAddress = formUrlObj.optString("formurl");
                    String formType = formUrlObj.optString("type");
                    botMsg.setBotFormUrl(new BotFormUrl(formTitle, formAddress, formType));
                }

                // 解析 tag
                if (jsonObj.has("tags")) {
                    ArrayList<BotTag> botTags = new ArrayList<>();
                    JSONArray tagArray = JsonHelper.getJsonArray(JsonHelper.getJsonObject(jsonObj, "tags"), "tag");
                    for (int i = 0; i < tagArray.length(); i++) {
                        JSONObject obj = tagArray.getJSONObject(i);
                        if (obj.has("tag")) {
                            JSONObject jsonObject = JsonHelper.getJsonObject(obj, "tag");
                            botTags.add(new BotTag(jsonObject.optInt("id"), jsonObject.optString("name")));
                        }
                    }
                    botMsg.setBotTagList(botTags);
                }

                // 判断下是不是没查到结果
                if (jsonObj.has("alicekm")) {
                    if ("wildcard".equals(JsonHelper.getJsonObject(jsonObj, "alicekm").optString("type"))) {
                        botMsg.setBotStupid(true);
                    }
                }

            } catch (Exception e) {
                botMsg.setBotStupid(true);
                TLog.e("ElvaBot getLocalReply() Exception -> " + e.toString());
                AIHelpLogger.error("ElvaBot getLocalReply exception", e);
            }
        } else {
            botMsg.setBotStupid(true);
        }
        return prepareRawResponseForMsg(botMsg);
    }

    private static boolean isElvaPrepared() {
        boolean prepared = sBotInstance != null;
        if (!prepared) AIHelpLogger.error("isElvaPrepared", new UnknownError("sBotInstance == null"));
        return prepared;
    }

    public static ConversationMsg getMqttReply(String response, boolean... isWelcomeMsg) {

        ElvaBotMsg botMsg = new ElvaBotMsg();
        if (isWelcomeMsg.length == 0) {
            botMsg.setRawResponse(response);
        }

        try {
            // 解析用户输入后得到的 json 数据
            JSONObject jsonObj = new JSONObject(response);

            // 解析时间戳
            if (jsonObj.has("timeMillis")) {
                botMsg.setTimeStamp(jsonObj.getLong("timeMillis"));
            }

            // 解析 msg
            if (jsonObj.has("msg")) {
                botMsg.setBotMsg(jsonObj.optString("msg"));
            }

            // 是否有精准、相似匹配
            botMsg.setSimilarMatched(jsonObj.has("isSimilarMatch"));

            // question
            botMsg.setUserInput(jsonObj.optString("question"));

            // 解析 action 信息
            if (jsonObj.has("actions")) {
                ArrayList<String> actions = new ArrayList<>();
                JSONArray actionArray = JsonHelper.getJsonArray(jsonObj, "actions");
                for (int i = 0; i < actionArray.length(); i++) {
                    actions.add(actionArray.getJSONObject(i).optString("reply"));
                }
                botMsg.setActions(actions);
            }

            // 解析外链
            if (jsonObj.has("url")) {
                JSONObject urlObj = JsonHelper.getJsonObject(jsonObj, "url");
                String urlTitle = urlObj.optString("title");
                String urlAddress = urlObj.optString("content");
                botMsg.setBotUrl(new BotUrl(urlTitle, urlAddress));
            }

            // 解析表单链接
            if (jsonObj.has("url2")) {
                JSONObject formUrlObj = JsonHelper.getJsonObject(jsonObj, "url2");
                String formTitle = formUrlObj.optString("title");
                String formAddress = formUrlObj.optString("formurl");
                String formType = formUrlObj.optString("type");
                botMsg.setBotFormUrl(new BotFormUrl(formTitle, formAddress, formType));
                StatisticHelper.whenFormEventHappened(botMsg.getTimeStamp(), StatisticHelper.FORM_ACTION_DISPLAYED);
            }

            // 解析 tag
            if (jsonObj.has("tags")) {
                ArrayList<BotTag> botTags = new ArrayList<>();
                JSONArray tagArray = JsonHelper.getJsonArray(jsonObj, "tags");
                for (int i = 0; i < tagArray.length(); i++) {
                    JSONObject obj = tagArray.getJSONObject(i);
                    if (obj.has("tag")) {
                        JSONObject jsonObject = JsonHelper.getJsonObject(obj, "tag");
                        botTags.add(new BotTag(jsonObject.optInt("id"), jsonObject.optString("name")));
                    } else if (obj.has("id") && obj.has("name")) {
                        botTags.add(new BotTag(obj.optInt("id"), obj.optString("name")));
                    }
                }
                botMsg.setBotTagList(botTags);
            }

            if (jsonObj.has("template")) {
                botMsg.setTemplate(jsonObj.optString("template"));
            }

            if (jsonObj.has("alicekm")) {
                JSONObject aliceObject = JsonHelper.getJsonObject(jsonObj, "alicekm");
                switch (aliceObject.optString("type")) {
                    case "faq":
                        botMsg.setMsgType(ConversationMsg.TYPE_ADMIN_FAQ);
                        botMsg.setMsgStatus(ConversationMsg.STATUS_FAQ_NORMAL);
                        botMsg.setFaqId(aliceObject.optString("id"));
                        LogoutMqttHelper.updateType(LogoutMqttHelper.LOGOUT_TYPE_FAQ_DISPLAY);
                        logElvaFAQViewed(botMsg);
                        break;
                    case "wildcard":
                        botMsg.setBotStupid(true);
                        LogoutMqttHelper.updateType(LogoutMqttHelper.LOGOUT_TYPE_BOT_STUPID);
                        break;
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            AIHelpLogger.error("ElvaBot getMqttReply exception", e);
        }
        return botMsg;
    }

    private static void logElvaFAQViewed(ElvaBotMsg botMsg) {
//        String faqContentId = "";
//        if (botMsg.isHasUrl()) {
//            int index = TextUtils.indexOf(botMsg.getBotUrl().getUrlAddress(), "?id=");
//            if (index != -1) {
//                faqContentId = botMsg.getBotUrl().getUrlAddress().substring(index + "?id=".length());
//                StatisticHelper.markElvaFAQViewed(botMsg.getTimeStamp(), faqContentId, botMsg.getFaqId());
//            }
//        }
    }

    private static ElvaBotMsg prepareRawResponseForMsg(ElvaBotMsg botMsg) {
        if (botMsg.isBotStupid()) {
            botMsg.setRawResponse("");
            return botMsg;
        }
        JSONObject rawResponse = new JSONObject();
        try {
            rawResponse.put("timeMillis", botMsg.getTimeStamp());
            rawResponse.put("question", botMsg.getUserInput());
            rawResponse.put("msg", botMsg.getBotMsg());

            if (botMsg.isHasAction()) {
                JSONArray actions = new JSONArray();
                for (String actionName : botMsg.getActions()) {
                    JSONObject action = new JSONObject();
                    action.put("action", actionName);
                    action.put("reply", actionName);
                    actions.put(action);
                }
                rawResponse.put("actions", actions);
            }

            if (botMsg.isHasUrl()) {
                JSONObject url = new JSONObject();
                url.put("title", botMsg.getBotUrl().getUrlTitle());
                url.put("content", botMsg.getBotUrl().getUrlAddress());
                rawResponse.put("url", url);
            }

            if (botMsg.isHasFormUrl()) {
                JSONObject formUrl = new JSONObject();
                formUrl.put("title", botMsg.getBotFormUrl().getFormTitle());
                formUrl.put("formurl", botMsg.getBotFormUrl().getFormAddress());
                formUrl.put("type", botMsg.getBotFormUrl().getFormType());
                rawResponse.put("url2", formUrl);
            }

            if (botMsg.isHasTag()) {
                JSONArray tags = new JSONArray();
                for (BotTag botTag : botMsg.getBotTagList()) {
                    JSONObject tag = new JSONObject();
                    tag.put("id", botTag.getTagId());
                    tag.put("name", botTag.getTagName());
                    tags.put(tag);
                }
                rawResponse.put("tags", tags);
            }
            botMsg.setRawResponse(rawResponse.toString());
        } catch (JSONException e) {
            e.printStackTrace();
            AIHelpLogger.error("ElvaBot prepareRawResponseForMsg exception", e);
        }
        return botMsg;
    }

}
