package net.aihelp.ui.helper;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;

import net.aihelp.utils.TLog;


public class BitmapHelper {

    public static int[] computeSize(String path) {
        int[] size = new int[2];
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(path, options);
        float realWidth = options.outWidth;
        float realHeight = options.outHeight;

        double scale = Math.ceil(Math.max(realHeight, realWidth) / 700);
        if (scale <= 1) scale = 1;

        size[0] = (int) (realWidth / scale);
        size[1] = (int) (realHeight / scale);
        TLog.e(String.format("宽高信息为：%s -> %s", realWidth + "x" + realHeight, size[0] + "x" + size[1] ));
        return size;
    }

}
