package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.common.ConfigValues;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NetErrorEvent;
import net.aihelp.data.event.SearchBackEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.utils.SoftInputUtil;


public class SectionRootFragment extends BaseFaqFragment<FaqPresenter> {

    private boolean isModeFAQ;
    private boolean isSearchSessionOpen;
    EditText editText;
    TextView tvCancel;

    public static SectionRootFragment newInstance(Bundle bundle) {
        SectionRootFragment faqFragment = new SectionRootFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(final View view) {

        editText = get(R.id.aihelp_et_search);
        tvCancel = get(R.id.aihelp_tv_cancel_search);
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (!isSearchSessionOpen && hasFocus) {
                    getFaqFlowListener().onIntentToSearch(getMergedBundle());
                    tvCancel.setVisibility(View.VISIBLE);
                    isSearchSessionOpen = true;
                }
            }
        });
        editText.addTextChangedListener(getFaqFlowListener());
        tvCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clearInputFocus();
            }
        });

        Bundle arguments = getArguments();
        if (arguments != null) {
            int supportMoment = arguments.getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);
            if (supportMoment == ConfigValues.MOMENT_NEVER) {
                EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
                return;
            }
            mPresenter.prepareFAQNotification();
        }

    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        getFaqFlowListener().onIntentToSectionList(extras);
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_section_root;
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void onEventComing(EventCenter event) {

        if (event instanceof NetErrorEvent) {
            get(R.id.aihelp_ll_search).setVisibility(View.GONE);
            return;
        }
        if (event instanceof SearchBackEvent) {
            clearInputFocus();
        }

    }

    private void clearInputFocus() {
        tvCancel.setVisibility(View.GONE);
        editText.setText("");
        editText.clearFocus();

        if (getContext() != null) {
            SoftInputUtil.hideSoftInput(getContext(), editText);
        }

        if (getFragmentManager() != null) {
            int backStackCount = getFragmentManager().getBackStackEntryCount();
            if (backStackCount > 0) {
                getFragmentManager().popBackStack();
            }
        }

        isSearchSessionOpen = false;
    }

    @Override
    public void onDestroy() {
        if (mPresenter != null) mPresenter.logoutFaqMqtt();
        super.onDestroy();
    }

}
