package net.aihelp.ui.faq;

import android.content.Context;
import android.os.Bundle;
import android.view.View;

import net.aihelp.R;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NetErrorEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.db.faq.pojo.DisplayFaq;
import net.aihelp.ui.adapter.FaqListAdapter;

import java.util.List;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class SectionListFragment extends BaseFaqFragment<FaqPresenter> {

    private FaqListAdapter mSectionAdapter;

    public static SectionListFragment newInstance(Bundle bundle) {
        SectionListFragment faqFragment = new SectionListFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        EventBus.getDefault().post(new EventCenter<>());
    }

    @Override
    protected void initEventAndData(final View view) {
        prepareRecyclerView();
    }

    private void prepareRecyclerView() {
        RecyclerView rvSection = get(R.id.aihelp_rv_faq_section);
        rvSection.setLayoutManager(new LinearLayoutManager(getContext()));
        mSectionAdapter = new FaqListAdapter(getContext());
        mSectionAdapter.setOnSectionSelectedListener(new FaqListAdapter.FaqSelectedListenerWrapper() {

            @Override
            public void onIntentFromRootSectionList(boolean isHasSubSection, String secId) {
                Bundle bundle = getMergedBundle();
                bundle.putString(IntentValues.SECTION_ID, secId);
                getFaqFlowListener().onIntentToQuestionList(bundle);
            }

        });
        rvSection.setAdapter(mSectionAdapter);

        mPresenter.goFetchFAQDataSource();
    }

    @Override
    public void onResume() {
        super.onResume();
        // mPresenter.goFetchFAQDataSource();
    }

    @Override
    protected int getLoadingTargetViewId() {
        return R.id.aihelp_rv_faq_section;
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_section_list;
    }

    @Override
    public void refreshList(List<DisplayFaq> displayFaqList) {
        // TODO: 2020/8/24 切换搜索时，会频繁刷页面，加上了 visible 判断，但是又会导致不显示
        // if (!isVisible()) return;
        mSectionAdapter.update(displayFaqList, true);
    }

    @Override
    public void showNetError() {
        super.showNetError();
        EventBus.getDefault().post(new NetErrorEvent());
    }

}
