package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;

import net.aihelp.R;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.SearchBackEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.db.faq.pojo.DisplayFaq;
import net.aihelp.ui.adapter.FaqListAdapter;
import net.aihelp.utils.SoftInputUtil;

import java.util.List;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class SearchFaqFragment extends BaseFaqFragment<FaqPresenter> {

    private RecyclerView rvSearchList;
    private FaqListAdapter mSearchAdapter;

    public static SearchFaqFragment newInstance(Bundle bundle) {
        SearchFaqFragment faqFragment = new SearchFaqFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View mView) {

        EventBus.getDefault().post(new EventCenter());

        prepareRecyclerView();

    }

    private void prepareRecyclerView() {
        rvSearchList = get(R.id.aihelp_rv_faq_search);
        rvSearchList.setLayoutManager(new LinearLayoutManager(getContext()));
        mSearchAdapter = new FaqListAdapter(getContext());
        mSearchAdapter.setOnSectionSelectedListener(new FaqListAdapter.FaqSelectedListenerWrapper(){
            @Override
            public void onIntentToQuestionContent(String faqId, String faqContentId, String match) {

                SoftInputUtil.hideSoftInput(getContext(), rvSearchList);

                Bundle bundle = getArguments() != null ? getArguments() : new Bundle();
                bundle.putString(IntentValues.FAQ_MAIN_ID, faqId);
                bundle.putString(IntentValues.FAQ_CONTENT_ID, faqContentId);
                bundle.putString(IntentValues.SEARCH_MATCH, match);
                getFaqFlowListener().onIntentToQuestionContent(bundle);
            }
        });
        rvSearchList.setAdapter(mSearchAdapter);
    }

    public void onQuery(String query) {
        mPresenter.goQueryFAQList(query);
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_search_faq;
    }

    @Override
    public void refreshList(List<DisplayFaq> matchedFaqList) {
        if (!isVisible()) return;
        if (matchedFaqList != null && matchedFaqList.size() == 0) {
            showSearchEmpty();
        } else {
            restoreViewState();
        }
        mSearchAdapter.update(matchedFaqList, true);
    }

    @Override
    protected int getLoadingTargetViewId() {
        return R.id.aihelp_rv_faq_search;
    }

    @Override
    public void onDetach() {
        super.onDetach();
        EventBus.getDefault().post(new SearchBackEvent());
    }

}
