package net.aihelp.ui.faq;

import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import net.aihelp.R;
import net.aihelp.common.IntentValues;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.db.faq.pojo.DisplayFaq;
import net.aihelp.ui.adapter.FaqListAdapter;

import java.util.List;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;


public class QuestionListFragment extends BaseFaqFragment<FaqPresenter> {

    private FaqListAdapter mAdapter;
    private TextView mTvTitle;

    public static QuestionListFragment newInstance(Bundle bundle) {
        QuestionListFragment faqFragment = new QuestionListFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View mView) {

        mTvTitle = get(R.id.aihelp_tv_question_title);
        RecyclerView rvSubSection = get(R.id.aihelp_rv_question);
        rvSubSection.setLayoutManager(new LinearLayoutManager(getContext()));
        mAdapter = new FaqListAdapter(getContext());
        mAdapter.setOnSectionSelectedListener(new FaqListAdapter.FaqSelectedListenerWrapper() {

            Bundle bundle = getMergedBundle();

            @Override
            public void onIntentFromSubSectionList(String subSectionId) {
                bundle.putString(IntentValues.SECTION_ID, subSectionId);
                getFaqFlowListener().onIntentToQuestionList(bundle);
            }

            @Override
            public void onIntentToQuestionContent(String faqId, String faqContentId, String match) {
                bundle.putString(IntentValues.FAQ_MAIN_ID, faqId);
                bundle.putString(IntentValues.FAQ_CONTENT_ID, faqContentId);
                getFaqFlowListener().onIntentToQuestionContent(bundle);
            }

        });
        rvSubSection.setAdapter(mAdapter);

    }

    @Override
    protected void getBundleAfterDataPrepared(@NonNull Bundle extras) {
        String sectionId = extras.getString(IntentValues.SECTION_ID);
        mPresenter.goFetchAutomaticForList(sectionId);
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_question_list;
    }

    @Override
    protected int getLoadingTargetViewId() {
        return R.id.aihelp_main_content;
    }

    @Override
    public void refreshList(List<DisplayFaq> displayFaqList, String listTitle) {
        mTvTitle.setText(listTitle);
        mAdapter.update(displayFaqList, true);
    }

}
