package net.aihelp.ui.faq;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.R;
import net.aihelp.common.ConfigValues;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.db.faq.pojo.RealFaq;
import net.aihelp.ui.adapter.TextWatcherAdapter;
import net.aihelp.ui.helper.FaqEvaluateHelper;
import net.aihelp.ui.helper.SkinHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;

import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;


public class QuestionContentFragment extends BaseFaqFragment<FaqPresenter> implements View.OnClickListener {

    private String mFaqMainId;
    private String mFaqContentId;

    private LinearLayout mQuestionFooter;
    private ViewGroup mEvaluateFaqLayout;
    private AppCompatImageView mIvUnHelpful;
    private AppCompatImageView mIvHelpful;
    private ViewGroup mAfterEvaluateLayout;
    private AppCompatTextView mTvAdvice;
    private AIHelpWebView mWebView;
    private AIHelpWebProgress mProgressBar;

    public static QuestionContentFragment newInstance(Bundle bundle) {
        QuestionContentFragment faqFragment = new QuestionContentFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void initEventAndData(View view) {
        prepareViews();
        prepareWebview(view);
        mQuestionFooter.setVisibility(Const.TOGGLE_EVALUATE_DETAIL_FAQ ? View.VISIBLE : View.GONE);
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        int supportMoment = extras.getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);
        if (supportMoment == ConfigValues.MOMENT_ONLY_IN_ANSWER_PAGE) {
            EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION, IntentValues.SUPPORT_ACTION_MSG));
        }

        mFaqMainId = extras.getString(IntentValues.FAQ_MAIN_ID);
        mFaqContentId = extras.getString(IntentValues.FAQ_CONTENT_ID);
        String searchTerm = extras.getString(IntentValues.SEARCH_MATCH);
        mPresenter.goFetchQuestionContent(mFaqMainId, searchTerm);
    }

    private void prepareWebview(View view) {
        mWebView.setWebViewClient(new AIHelpWebViewClient(getContext(), mProgressBar));
        mWebView.setWebChromeClient(new AIHelpWebChromeClient(this, mProgressBar));
    }

    private void prepareViews() {
        mQuestionFooter = get(R.id.aihelp_question_footer);
        mEvaluateFaqLayout = get(R.id.aihelp_ll_evaluate_faq);
        mIvUnHelpful = get(R.id.aihelp_iv_un_helpful);
        mIvHelpful = get(R.id.aihelp_iv_helpful);
        mAfterEvaluateLayout = get(R.id.aihelp_ll_feedback);
        mTvAdvice = get(R.id.aihelp_tv_advice);
        mWebView = get(R.id.aihelp_web_view);
        mProgressBar = get(R.id.aihelp_progress_bar);

        mIvUnHelpful.setOnClickListener(this);
        mIvHelpful.setOnClickListener(this);
        mTvAdvice.setOnClickListener(this);

        FaqEvaluateHelper.getInstance().setFaqDetailBundle(getArguments());
        FaqEvaluateHelper.getInstance().getViewsPrepared(mQuestionFooter, mEvaluateFaqLayout,
                mAfterEvaluateLayout, mTvAdvice);

        SkinHelper.updateIcon(SkinHelper.SKIN_FAQ_UNHELPFUL, mIvUnHelpful);
        SkinHelper.updateIcon(SkinHelper.SKIN_FAQ_HELPFUL, mIvHelpful);
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_question_content;
    }

    @Override
    protected int getLoadingTargetViewId() {
        return R.id.aihelp_ll_root;
    }

    public void refreshQuestionContent(RealFaq faq) {
        super.refreshQuestionContent(faq);
        mQuestionFooter.setVisibility((Const.TOGGLE_EVALUATE_DETAIL_FAQ &&
                faq.isHelpful() == 0) ? View.VISIBLE : View.GONE);
        mWebView.loadDataWithBaseURL(null, faq.getFaqContent(), "text/html",
                "utf-8", null);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.aihelp_iv_un_helpful || v.getId() == R.id.aihelp_iv_helpful) {
            FaqEvaluateHelper.getInstance().updateEvaluateFaq(
                    v.getId() == R.id.aihelp_iv_helpful, mFaqMainId, mFaqContentId);
            return;
        }

        if (v.getId() == R.id.aihelp_tv_advice) {
            FaqEvaluateHelper.getInstance().showAdviceAlert(getContext(), mFaqMainId, false);
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        mProgressBar.hide();
    }

    public boolean onBackPressed() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
            return false;
        }
        return true;
    }

}
