package net.aihelp.ui.faq;

import android.os.Bundle;

import net.aihelp.R;
import net.aihelp.common.ConfigValues;
import net.aihelp.common.Const;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.LoadingElvaEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.data.logic.FaqPresenter;
import net.aihelp.data.logic.MqttCallbackImpl;
import net.aihelp.db.faq.pojo.DisplayFaq;
import net.aihelp.db.faq.pojo.RealFaq;
import net.aihelp.ui.SupportFragment;
import net.aihelp.ui.helper.ResponseMqttHelper;
import net.aihelp.ui.helper.StatisticHelper;

import java.util.Iterator;
import java.util.List;

import androidx.fragment.app.Fragment;

public abstract class BaseFaqFragment<T extends FaqPresenter> extends BaseFragment<T> {

    private boolean isAlreadyInFAQ;

    // TODO: 2020/6/17 太危险了，感觉随时会空指针
    IFaqEventListener getFaqFlowListener() {
        Fragment parentFragment = getParentFragment();
        if (!(parentFragment instanceof SupportFragment)) {
            parentFragment = parentFragment.getParentFragment();
        }
        return ((IFaqParentView) parentFragment).getFaqEventListener();
    }

    @Override
    public void onResume() {
        super.onResume();

        EventBus.getDefault().post(new LoadingElvaEvent(IntentValues.HIDE_CS_LOADING));

        if (Const.TOGGLE_OPEN_FAQ_NOTIFICATION) {
            MqttCallbackImpl.getInstance().updateHostView(this);
        }

        // 在 FAQ 页面填写表单
        if (isAlreadyInFAQ && !isVisible()) return;

        // 判断当前是否有未读消息，如果有未读消息，要显示未读标记
        if (null != getArguments()) {

            int supportMoment = getArguments().getInt(IntentValues.FAQ_SUPPORT_MOMENT, ConfigValues.MOMENT_NEVER);

            if (supportMoment == ConfigValues.MOMENT_NEVER) {
                EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
                return;
            }

            if (ResponseMqttHelper.isHasUnreadMsg()) {
                EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION,
                        IntentValues.SUPPORT_ACTION_MSG_UNREAD));
            } else if (supportMoment == ConfigValues.MOMENT_ALWAYS || ResponseMqttHelper.isTicketUnFinish()) {
                EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION,
                        IntentValues.SUPPORT_ACTION_MSG));
            } else {
                switch (supportMoment) {
                    case ConfigValues.MOMENT_ONLY_IN_ANSWER_PAGE:
                    case ConfigValues.MOMENT_AFTER_MARKING_UNHELPFUL:
                        if (!QuestionContentFragment.class.getSimpleName().equals(getClass().getSimpleName())) {
                            EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
                        }
                        break;
                    default:
                        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
                        break;
                }
            }

        }

        isAlreadyInFAQ = true;

    }

    Bundle getMergedBundle() {
        Bundle arguments = new Bundle(getArguments());
        String[] excludedKeys = new String[]{IntentValues.SECTION_ID, IntentValues.SUB_SECTION_ID,
                IntentValues.FAQ_MAIN_ID};
        outer:
        for (String excludedKey : excludedKeys) {
            Iterator<String> iterator = arguments.keySet().iterator();
            while (iterator.hasNext()) {
                String bundleKey = iterator.next();
                if (excludedKey.equals(bundleKey)) {
                    iterator.remove();
                    break outer;
                }
            }
        }
        return arguments;
    }

    public void refreshList(List<DisplayFaq> displayFaqList) {

    }

    public void refreshList(List<DisplayFaq> displayFaqList, String listTitle) {

    }

    public void refreshQuestionContent(RealFaq faq) {
        if (faq == null) return;
        StatisticHelper.whenFAQDetailVisible(faq.getFaqMainId(), faq.getFaqContentId());
    }

    void showSearchEmpty() {
        super.showEmpty(R.layout.aihelp_layout_empty_search);
    }

    @Override
    public void showEmpty(int... layoutId) {
        super.showEmpty(R.layout.aihelp_layout_list_empty);
    }

    public void showSupportActionUnread() {
        // Ensure the current page is visible before marking there is unread messages,
        // Otherwise when user chats with CS in conversation page, then come back to FAQ page,
        // there will be a new message notification which is actually not exists.
        if (isVisible()) {
            EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION,
                    IntentValues.SUPPORT_ACTION_MSG_UNREAD));
            ResponseMqttHelper.setHasUnreadMsg(true);
        }
    }

    public void showSupportAction() {
        EventBus.getDefault().post(new SupportActionEvent(IntentValues.SHOW_SUPPORT_ACTION,
                IntentValues.SUPPORT_ACTION_MSG));
        ResponseMqttHelper.setTicketUnFinish(true);
    }

}
