package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.webkit.JavascriptInterface;

import net.aihelp.R;
import net.aihelp.common.IntentValues;
import net.aihelp.core.ui.BaseFragment;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.event.SkinUpdateEvent;
import net.aihelp.data.event.SupportActionEvent;
import net.aihelp.ui.helper.AttachmentDataProvider;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.TLog;
import net.aihelp.utils.ToastUtil;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class IntentUrlFragment extends BaseFragment {

    private AIHelpWebView mWebView;
    private AIHelpWebChromeClient mClient;

    public static IntentUrlFragment newInstance(Bundle bundle) {
        IntentUrlFragment formFragment = new IntentUrlFragment();
        formFragment.setArguments(bundle);
        return formFragment;
    }

    @SuppressLint({"JavascriptInterface", "AddJavascriptInterface"})
    @Override
    protected void initEventAndData(View view) {
        EventBus.getDefault().post(new SkinUpdateEvent(IntentValues.HIDE_NAVIGATION_SKIN));
        mWebView = (AIHelpWebView) get(R.id.aihelp_web_view);
        AIHelpWebProgress mProgressBar = (AIHelpWebProgress) get(R.id.aihelp_progress_bar);
        mWebView.setWebViewClient(new AIHelpWebViewClient(getContext(), mProgressBar));
        mClient = new AIHelpWebChromeClient(this, mProgressBar);
        mWebView.setWebChromeClient(mClient);

        if (getActivity() != null) {
            mWebView.addJavascriptInterface(getActivity(), "android");
        }
    }

    @Override
    protected void getBundleAfterDataPrepared(Bundle extras) {
        String intentUrl = extras.getString(IntentValues.INTENT_URL);
        mWebView.loadUrl(intentUrl);
        TLog.e("Intent URL is " + intentUrl);
    }

    @Override
    public void onResume() {
        super.onResume();
        EventBus.getDefault().post(new SupportActionEvent(IntentValues.HIDE_SUPPORT_ACTION));
    }

    @Override
    protected int getLayout() {
        return R.layout.aihelp_fra_intent_url;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (mClient != null) {
            mClient.onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean onBackPressed() {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
            return false;
        }
        return true;
    }

    @Permission(requestCode = 1001)
    public void launchPicker(Permission.Result result, final IPermissionCallback callback) {
        switch (result) {
            case GRANTED:
                startActivityForResult(AttachmentDataProvider.getIntentForMedia(), AIHelpWebChromeClient.REQUEST_CODE);
                break;
            case DENIED:
                if (mClient != null) mClient.cancelChooseFileDialog();
                ToastUtil.showRawSnackBar(getActivity(), getString(R.string.aihelp_permission_denied), Snackbar.LENGTH_SHORT);
                break;
            case RATIONAL:
                if (mClient != null) mClient.cancelChooseFileDialog();
                ToastUtil.showRawSnackBar(getActivity(), getString(R.string.aihelp_permission_denied),
                        getString(R.string.aihelp_yes), Snackbar.LENGTH_INDEFINITE, new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                callback.onPermissionRational();
                            }
                        });
                break;
            case GO_SETTING:
                if (mClient != null) mClient.cancelChooseFileDialog();
                ToastUtil.showRawSnackBar(getActivity(), getString(R.string.aihelp_permission_ignored),
                        getString(R.string.aihelp_permission_settings), Snackbar.LENGTH_SHORT, new View.OnClickListener() {
                            @Override
                            public void onClick(View v) {
                                callback.onPermissionIgnored();
                            }
                        });
                break;
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        AIHelpPermissions.getInstance().onRequestPermissionsResult(grantResults.length == 1 && grantResults[0] == 0);
    }

}
