package net.aihelp.ui.cs;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.db.AIHelpDBHelper;
import net.aihelp.db.faq.pojo.RealFaq;
import net.aihelp.ui.helper.FaqEvaluateHelper;
import net.aihelp.ui.helper.StatisticHelper;
import net.aihelp.ui.webkit.AIHelpWebChromeClient;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpBottomSheetDialog;
import net.aihelp.ui.widget.AIHelpBottomSheetWebView;

import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.fragment.app.Fragment;


public class ElvaFaqBottomSheetEvent implements View.OnClickListener {

    private Context mContext;
    private AIHelpBottomSheetDialog faqDialog;
    private AIHelpBottomSheetWebView mWebView;
    private AIHelpWebChromeClient mClient;

    private String mFaqMainId;
    private String mFaqContentId;
    private LinearLayout mQuestionFooter;

    @SuppressLint("ClickableViewAccessibility")
    public ElvaFaqBottomSheetEvent(Fragment fragment) {

        if (fragment == null || fragment.getContext() == null) return;
        this.mContext = fragment.getContext();

        faqDialog = new AIHelpBottomSheetDialog(mContext, R.layout.aihelp_dia_elva_faq, false);
        faqDialog.setCanceledOnTouchOutside(true);

        View contentView = faqDialog.getContentView();
        contentView.findViewById(R.id.aihelp_iv_close).setOnClickListener(this);
        contentView.findViewById(R.id.aihelp_tv_advice).setOnClickListener(this);
        contentView.findViewById(R.id.aihelp_iv_un_helpful).setOnClickListener(this);
        contentView.findViewById(R.id.aihelp_iv_helpful).setOnClickListener(this);

        mQuestionFooter = contentView.findViewById(R.id.aihelp_question_footer);
        ViewGroup evaluateFaqLayout = contentView.findViewById(R.id.aihelp_ll_evaluate_faq);
        ViewGroup afterEvaluateLayout = contentView.findViewById(R.id.aihelp_ll_feedback);
        AppCompatTextView tvAdvice = contentView.findViewById(R.id.aihelp_tv_advice);
        FaqEvaluateHelper.getInstance().getViewsPrepared(mQuestionFooter, evaluateFaqLayout,
                afterEvaluateLayout, tvAdvice);

        mWebView = contentView.findViewById(R.id.aihelp_web_view);
        final ImageView ivBack = contentView.findViewById(R.id.aihelp_iv_back);
        ivBack.setOnClickListener(this);
        AIHelpWebProgress progressBar = contentView.findViewById(R.id.aihelp_progress_bar);

        AIHelpWebViewClient webViewClient = new AIHelpWebViewClient(mContext, progressBar);
        mWebView.setWebViewClient(webViewClient);
        mClient = new AIHelpWebChromeClient(fragment, progressBar);
        mWebView.setWebChromeClient(mClient);
        mWebView.bindToBottomSheet();

        webViewClient.setUrlLoadingListener(new AIHelpWebViewClient.ShouldOverrideUrlLoadingListener() {
            @Override
            public void handleUrlClick(boolean result) {
                if (result) {
                    // TODO: 2020/8/22 FAQ 有超链接的时候，进入以后就无法返回了
                    ivBack.setVisibility(View.VISIBLE);
                }
            }
        });

    }

    private void onBackPressed(View view) {
        if (mWebView.canGoBack()) {
            mWebView.goBack();
            if (!mWebView.canGoBack()) view.setVisibility(View.GONE);
        }
    }

    public void show(RealFaq faq) {
        if (faqDialog != null) faqDialog.show();
        mWebView.loadDataWithBaseURL(null, faq.getFaqContent(), "text/html", "utf-8", null);
    }

    public void show(String faqUrl) {
        int index = TextUtils.indexOf(faqUrl, "?id=");
        if (index != -1) {
            mFaqContentId = faqUrl.substring(index + "?id=".length());
            RealFaq realFaq = AIHelpDBHelper.getInstance().getFaqByContentId(mFaqContentId);
            if (realFaq != null) {
                mFaqMainId = realFaq.getFaqMainId();
                mQuestionFooter.setVisibility((Const.TOGGLE_EVALUATE_DETAIL_FAQ &&
                        realFaq.isHelpful() == 0) ? View.VISIBLE : View.GONE);
            }
        }

        if (faqDialog != null) faqDialog.show();
        mWebView.loadUrl(faqUrl);
    }

    @Override
    public void onClick(View v) {
        if (faqDialog == null) return;

        if (v.getId() == R.id.aihelp_iv_close) {
            faqDialog.dismiss();
        }

        if (v.getId() == R.id.aihelp_iv_back) {
            onBackPressed(v);
        }

        if (v.getId() == R.id.aihelp_iv_un_helpful || v.getId() == R.id.aihelp_iv_helpful) {
            FaqEvaluateHelper.getInstance().updateEvaluateFaq(
                    v.getId() == R.id.aihelp_iv_helpful, mFaqMainId, mFaqContentId);
            return;
        }

        if (v.getId() == R.id.aihelp_tv_advice) {
            FaqEvaluateHelper.getInstance().showAdviceAlert(mContext, mFaqMainId, true);
        }

    }

}
