package net.aihelp.ui.behavior;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import net.aihelp.ui.widget.material.CoordinatorLayout;
import net.aihelp.utils.TLog;

import androidx.recyclerview.widget.RecyclerView;


public class RecyclerViewBehavior extends CoordinatorLayout.Behavior<RecyclerView> {

    public RecyclerViewBehavior() {
    }

    public RecyclerViewBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean layoutDependsOn(CoordinatorLayout parent, RecyclerView child, View dependency) {
        return dependency instanceof TextView;
    }

    @Override
    public boolean onDependentViewChanged(CoordinatorLayout parent, RecyclerView child, View dependency) {

        // 调整 RecyclerView 的位置
        CoordinatorLayout.LayoutParams dependencyParams = (CoordinatorLayout.LayoutParams) dependency.getLayoutParams();
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams) child.getLayoutParams();
        layoutParams.topMargin = dependency.getHeight() + dependencyParams.topMargin + dependencyParams.bottomMargin;
        child.setLayoutParams(layoutParams);
        return true;
    }
}
