package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.helper.SkinHelper;
import net.aihelp.utils.DeviceInfoUtil;

import androidx.appcompat.widget.AppCompatImageButton;


public class UserTextAdapter extends BaseMsgAdapter {

    public UserTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return R.layout.aihelp_ada_msg_user;
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_USER_TEXT ||
                item.getMsgType() == ConversationMsg.TYPE_USER_TEXT_BOT;
    }

    @Override
    public void convert(final ViewHolder holder, final ConversationMsg s, final int position) {
        updateMsgSendingStatus(holder, s.getMsgContent(), s.getMsgStatus());
        holder.setOnClickListener(R.id.aihelp_iv_msg_retry, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mWrapper != null) {
                    mWrapper.onRetrySendingMessage(position, s);
                }
            }
        });

    }

    private void updateMsgSendingStatus(ViewHolder holder, String msgContent, int status) {

        holder.setVisible(R.id.aihelp_iv_portrait, Const.TOGGLE_SHOW_PORTRAIT);
        SkinHelper.updateIcon(SkinHelper.SKIN_PORTRAIT_USER, holder.getView(R.id.aihelp_iv_portrait));

        TextView msgView = holder.getView(R.id.aihelp_admin_message_text);
        msgView.setText(getUrlSupportedText(msgContent));
        msgView.setMovementMethod(LinkMovementMethod.getInstance());
        msgView.setMaxWidth(Math.max(getRightfulMaxWidth(holder), dip2px(mContext, 200)));

        AppCompatImageButton retryButton = holder.getView(R.id.aihelp_iv_msg_retry);

        switch (status) {
            case ConversationMsg.STATUS_SUCCESS:
                updateMsgBackground(msgView, isCurrentRtl ? R.drawable.aihelp_bg_msg_user_ar : R.drawable.aihelp_bg_msg_user);
                holder.setVisible(R.id.aihelp_iv_msg_sending, false);
                holder.setVisible(R.id.aihelp_iv_msg_retry, false);
                msgView.setTextColor(Color.parseColor("#333333"));
                break;
            case ConversationMsg.STATUS_SENDING:
                updateMsgBackground(msgView, isCurrentRtl ? R.drawable.aihelp_bg_msg_user_sending_ar : R.drawable.aihelp_bg_msg_user);
                holder.setVisible(R.id.aihelp_iv_msg_sending, true);
                holder.setVisible(R.id.aihelp_iv_msg_retry, false);
                msgView.setTextColor(Color.parseColor("#777982"));
                break;
            case ConversationMsg.STATUS_RETRY:
                updateMsgBackground(msgView, isCurrentRtl ? R.drawable.aihelp_bg_msg_user_ar : R.drawable.aihelp_bg_msg_user);
                holder.setVisible(R.id.aihelp_iv_msg_sending, false);
                holder.setVisible(R.id.aihelp_iv_msg_retry, true);
                retryButton.setImageResource(R.drawable.aihelp_svg_iv_msg_retry);
                msgView.setTextColor(Color.parseColor("#333333"));
                break;
            case ConversationMsg.STATUS_FAILURE:
                updateMsgBackground(msgView, isCurrentRtl ? R.drawable.aihelp_bg_msg_user_ar : R.drawable.aihelp_bg_msg_user);
                holder.setVisible(R.id.aihelp_iv_msg_sending, false);
                holder.setVisible(R.id.aihelp_iv_msg_retry, true);
                retryButton.setImageResource(R.drawable.aihelp_svg_iv_msg_failed);
                msgView.setTextColor(Color.parseColor("#333333"));
                break;
        }
    }

    private int getRightfulMaxWidth(ViewHolder holder) {
        ImageView ivPortrait = holder.getView(R.id.aihelp_iv_portrait);
        TextView tvMsg = holder.getView(R.id.aihelp_admin_message_text);
        int screenWidth = mContext.getResources().getDisplayMetrics().widthPixels;
        return screenWidth - (dip2px(mContext, 39) +
                ((ViewGroup.MarginLayoutParams) ivPortrait.getLayoutParams()).rightMargin +
                ((ViewGroup.MarginLayoutParams) tvMsg.getLayoutParams()).rightMargin) * 2;
    }

    private void updateMsgBackground(TextView msgView, int resourceId) {
        if (TextUtils.isEmpty(SkinHelper.getSkinResource(SkinHelper.SKIN_USER_MSG))) {
            msgView.setBackgroundResource(resourceId);
        } else {
            SkinHelper.updateBackground(SkinHelper.SKIN_USER_MSG, msgView);
        }
    }

}
