package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;

import net.aihelp.R;
import net.aihelp.common.Const;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.ui.image.Picasso;
import net.aihelp.core.util.viewer.ImageViewer;
import net.aihelp.data.model.cs.ConversationMsg;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.helper.SkinHelper;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.TLog;

import androidx.appcompat.widget.AppCompatImageView;


public class UserImageAdapter extends BaseMsgAdapter {

    public UserImageAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return R.layout.aihelp_ada_msg_user_image;
    }

    @Override
    public boolean isForViewType(ConversationMsg item, int position) {
        return item.getMsgType() == ConversationMsg.TYPE_USER_IMAGE;
    }

    @Override
    public void convert(ViewHolder holder, final ConversationMsg conversationMsg, final int position) {

        holder.setVisible(R.id.aihelp_iv_portrait, Const.TOGGLE_SHOW_PORTRAIT);
        SkinHelper.updateIcon(SkinHelper.SKIN_PORTRAIT_USER, holder.getView(R.id.aihelp_iv_portrait));

        holder.setVisible(R.id.aihelp_iv_msg_retry, false);

        final AIHelpLoadingImageView imageView = holder.getView(R.id.aihelp_iv_holder);
        imageView.loadIntoImageView(mContext, conversationMsg);

        if (conversationMsg.getMsgStatus() == ConversationMsg.STATUS_RETRY) {
            holder.setVisible(R.id.aihelp_iv_msg_retry, true);
            holder.setOnClickListener(R.id.aihelp_iv_msg_retry, new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null) {
                        mWrapper.onRetrySendingMessage(position, conversationMsg);
                    }
                }
            });
            return;
        }

        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
                ImageViewer imageViewer = ImageViewer.getDefault(mContext);
                imageViewer.updateImageResource(conversationMsg.getMsgContent());
                imageViewer.show();

            }
        });

    }

}
